/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java.types;

import com.snowflake.snowpark.internal.JavaDataTypeUtils;
import com.snowflake.snowpark_java.types.ColumnIdentifier;
import com.snowflake.snowpark_java.types.DataType;
import java.util.Objects;

public class StructField {
    private final com.snowflake.snowpark.types.StructField field;

    public StructField(ColumnIdentifier columnIdentifier, DataType dataType, boolean nullable) {
        this(new com.snowflake.snowpark.types.StructField(columnIdentifier.toScalaColumnIdentifier(), JavaDataTypeUtils.javaTypeToScalaType(dataType), nullable));
    }

    public StructField(ColumnIdentifier columnIdentifier, DataType dataType) {
        this(columnIdentifier, dataType, true);
    }

    public StructField(String name, DataType dataType, boolean nullable) {
        this(com.snowflake.snowpark.types.StructField.apply(name, JavaDataTypeUtils.javaTypeToScalaType(dataType), nullable));
    }

    public StructField(String name, DataType dataType) {
        this(name, dataType, true);
    }

    StructField(com.snowflake.snowpark.types.StructField field) {
        this.field = field;
    }

    public String name() {
        return this.field.name();
    }

    public ColumnIdentifier columnIdentifier() {
        return new ColumnIdentifier(this.field.columnIdentifier());
    }

    public DataType dataType() {
        return JavaDataTypeUtils.scalaTypeToJavaType(this.field.dataType());
    }

    public boolean nullable() {
        return this.field.nullable();
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof StructField) {
            return this.field.equals(((StructField)other).field);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.dataType(), this.nullable());
    }

    com.snowflake.snowpark.types.StructField toScalaStructField() {
        return this.field;
    }
}

