/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.maven;

import com.soebes.itf.jupiter.maven.MavenCacheResult;
import com.soebes.itf.jupiter.maven.MavenLog;
import com.soebes.itf.jupiter.maven.MavenProjectResult;
import java.util.StringJoiner;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class MavenExecutionResult {
    private final ExecutionResult result;
    private final int returnCode;
    private final MavenLog mavenLog;
    private final MavenProjectResult mavenProjectResult;
    private final MavenCacheResult mavenCacheResult;

    public MavenExecutionResult(ExecutionResult result, int returnCode, MavenLog mavenLog, MavenProjectResult mavenProjectResult, MavenCacheResult mavenCacheResult) {
        this.result = result;
        this.returnCode = returnCode;
        this.mavenLog = mavenLog;
        this.mavenProjectResult = mavenProjectResult;
        this.mavenCacheResult = mavenCacheResult;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean isSuccessful() {
        return ExecutionResult.Successful.equals((Object)this.result);
    }

    public boolean isFailure() {
        return ExecutionResult.Failure.equals((Object)this.result);
    }

    public ExecutionResult getResult() {
        return this.result;
    }

    public MavenLog getMavenLog() {
        return this.mavenLog;
    }

    public MavenCacheResult getMavenCacheResult() {
        return this.mavenCacheResult;
    }

    public MavenProjectResult getMavenProjectResult() {
        return this.mavenProjectResult;
    }

    public String toString() {
        return new StringJoiner(", ", MavenExecutionResult.class.getSimpleName() + "[", "]").add("result=" + (Object)((Object)this.result)).add("returnCode=" + this.returnCode).add("mavenLog=" + this.mavenLog).add("mavenProjectResult=" + this.mavenProjectResult).add("mavenCacheResult=" + this.mavenCacheResult).toString();
    }

    public static enum ExecutionResult {
        Successful,
        Failure;

    }
}

