/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.maven;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apiguardian.api.API;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public final class ProjectHelper {
    private ProjectHelper() {
    }

    public static Model readProject(InputStream inputStream) {
        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
        try {
            return mavenXpp3Reader.read(inputStream);
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed to read pom.xml", e);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.12.0")
    public static Model readProject(Path pomFile) {
        Model model;
        block8: {
            InputStream is = Files.newInputStream(pomFile, new OpenOption[0]);
            try {
                model = ProjectHelper.readProject(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read pom.xml", e);
                }
            }
            is.close();
        }
        return model;
    }
}

