/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv;

import com.soebes.maven.plugins.mlv.AbstractLicenseVerifierPlugIn;
import com.soebes.maven.plugins.mlv.ArtifactComperator;
import com.soebes.maven.plugins.mlv.LicenseInformation;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class LicenseVerifierMojo
extends AbstractLicenseVerifierPlugIn {
    public void execute() throws MojoExecutionException {
        this.loadLicensesFile();
        Set set = this.project.getArtifacts();
        if (set.isEmpty()) {
            this.getLog().info((CharSequence)"We haven't found any dependencies.");
            return;
        }
        this.getDependArtifacts(set);
        Collections.sort(this.getLicenseInformations(), new ArtifactComperator());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (this.licenseValidator.isValid(licenseInformation.getLicenses())) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("   ]VALID[   (" + licenseInformation.getArtifact().getScope() + ") The artifact " + licenseInformation.getProject().getId() + " has a license which is categorized as valid"));
                }
                bl = true;
                continue;
            }
            if (this.licenseValidator.isInvalid(licenseInformation.getLicenses())) {
                this.getLog().error((CharSequence)("  ]INVALID[ (" + licenseInformation.getArtifact().getScope() + ") The artifact " + licenseInformation.getProject().getId() + " has a license which is categorized as invalid"));
                bl2 = true;
                continue;
            }
            if (this.licenseValidator.isWarning(licenseInformation.getLicenses())) {
                this.getLog().warn((CharSequence)("]WARNING[ (" + licenseInformation.getArtifact().getScope() + ") The artifact " + licenseInformation.getProject().getId() + " has a license which is categorized as warning"));
                bl3 = true;
                continue;
            }
            if (!this.licenseValidator.isUnknown(licenseInformation.getLicenses())) continue;
            this.getLog().warn((CharSequence)("]UNKNOWN[ (" + licenseInformation.getArtifact().getScope() + ") The artifact " + licenseInformation.getProject().getId() + " has a license which is categorized as unknown"));
            bl4 = true;
        }
        if (bl && this.failOnValid) {
            throw new MojoExecutionException("A license which is categorized as VALID has been found.");
        }
        if (bl2 && this.failOnInvalid) {
            throw new MojoExecutionException("A license which is categorized as INVALID has been found.");
        }
        if (bl3 && this.failOnWarning) {
            throw new MojoExecutionException("A license which is categorized as WARNING has been found.");
        }
        if (bl4 && this.failOnUnknown) {
            throw new MojoExecutionException("A license which is categorized as UNKNOWN has been found.");
        }
    }
}

