/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv.model.io.xpp3;

import com.soebes.maven.plugins.mlv.model.LicenseItem;
import com.soebes.maven.plugins.mlv.model.LicensesContainer;
import com.soebes.maven.plugins.mlv.model.LicensesList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class LicensesXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, LicensesContainer licensesContainer) throws IOException {
        MXSerializer mXSerializer = new MXSerializer();
        mXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        mXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        mXSerializer.setOutput(writer);
        mXSerializer.startDocument(licensesContainer.getModelEncoding(), null);
        this.writeLicensesContainer(licensesContainer, "licenses", (XmlSerializer)mXSerializer);
        mXSerializer.endDocument();
    }

    public void write(OutputStream outputStream, LicensesContainer licensesContainer) throws IOException {
        MXSerializer mXSerializer = new MXSerializer();
        mXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        mXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        mXSerializer.setOutput(outputStream, licensesContainer.getModelEncoding());
        mXSerializer.startDocument(licensesContainer.getModelEncoding(), null);
        this.writeLicensesContainer(licensesContainer, "licenses", (XmlSerializer)mXSerializer);
        mXSerializer.endDocument();
    }

    private void writeLicenseItem(LicenseItem licenseItem, String string, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(NAMESPACE, string);
        if (licenseItem.getId() != null) {
            xmlSerializer.startTag(NAMESPACE, "id").text(licenseItem.getId()).endTag(NAMESPACE, "id");
        }
        if (licenseItem.getDescription() != null) {
            xmlSerializer.startTag(NAMESPACE, "description").text(licenseItem.getDescription()).endTag(NAMESPACE, "description");
        }
        if (licenseItem.getNames() != null && licenseItem.getNames().size() > 0) {
            xmlSerializer.startTag(NAMESPACE, "names");
            for (String string2 : licenseItem.getNames()) {
                xmlSerializer.startTag(NAMESPACE, "name").text(string2).endTag(NAMESPACE, "name");
            }
            xmlSerializer.endTag(NAMESPACE, "names");
        }
        if (licenseItem.getUrls() != null && licenseItem.getUrls().size() > 0) {
            xmlSerializer.startTag(NAMESPACE, "urls");
            for (String string2 : licenseItem.getUrls()) {
                xmlSerializer.startTag(NAMESPACE, "url").text(string2).endTag(NAMESPACE, "url");
            }
            xmlSerializer.endTag(NAMESPACE, "urls");
        }
        xmlSerializer.endTag(NAMESPACE, string);
    }

    private void writeLicensesContainer(LicensesContainer licensesContainer, String string, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(NAMESPACE, string);
        if (licensesContainer.getValid() != null) {
            this.writeLicensesList(licensesContainer.getValid(), "valid", xmlSerializer);
        }
        if (licensesContainer.getInvalid() != null) {
            this.writeLicensesList(licensesContainer.getInvalid(), "invalid", xmlSerializer);
        }
        if (licensesContainer.getWarning() != null) {
            this.writeLicensesList(licensesContainer.getWarning(), "warning", xmlSerializer);
        }
        xmlSerializer.endTag(NAMESPACE, string);
    }

    private void writeLicensesList(LicensesList licensesList, String string, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(NAMESPACE, string);
        if (licensesList.getLicenses() != null && licensesList.getLicenses().size() > 0) {
            for (LicenseItem licenseItem : licensesList.getLicenses()) {
                this.writeLicenseItem(licenseItem, "license", xmlSerializer);
            }
        }
        xmlSerializer.endTag(NAMESPACE, string);
    }
}

