/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.DirectMessagePublisherBuilder;
import com.solace.messaging.DirectMessageReceiverBuilder;
import com.solace.messaging.MessagingServiceClientBuilder;
import com.solace.messaging.PersistentMessagePublisherBuilder;
import com.solace.messaging.PersistentMessageReceiverBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.RequestReplyMessagePublisherBuilder;
import com.solace.messaging.RequestReplyMessageReceiverBuilder;
import com.solace.messaging.config.UpdatableConfiguration;
import com.solace.messaging.config.profile.ConfigurationProfile;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.util.AsyncConnectable;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.Connectable;
import com.solace.messaging.util.ErrorMonitoring;
import com.solace.messaging.util.Manageable;
import java.util.concurrent.CompletableFuture;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface MessagingService
extends Connectable,
AsyncConnectable,
Manageable,
ErrorMonitoring,
UpdatableConfiguration {
    @Override
    public MessagingService connect() throws PubSubPlusClientException;

    public <MessagingService> CompletableFuture<MessagingService> connectAsync() throws PubSubPlusClientException;

    public <MessagingService> void connectAsync(CompletionListener<MessagingService> var1) throws PubSubPlusClientException;

    public static MessagingServiceClientBuilder builder(ConfigurationProfile activeProfile) {
        return new MessagingServiceClientBuilder(activeProfile);
    }

    public DirectMessageReceiverBuilder createDirectMessageReceiverBuilder();

    public DirectMessagePublisherBuilder createDirectMessagePublisherBuilder();

    public PersistentMessageReceiverBuilder createPersistentMessageReceiverBuilder();

    public PersistentMessagePublisherBuilder createPersistentMessagePublisherBuilder();

    public RequestReplyMessagingService requestReply();

    public OutboundMessageBuilder messageBuilder();

    public String getApplicationId();

    @Override
    public void updateProperty(String var1, Object var2) throws PubSubPlusClientException;

    @ProviderType
    public static interface ServiceEvent {
        public long getTimestamp();

        public String getBrokerURI();

        public String getMessage();

        public PubSubPlusClientException getCause();
    }

    @FunctionalInterface
    public static interface ServiceInterruptionListener {
        public void onServiceInterrupted(ServiceEvent var1);
    }

    @FunctionalInterface
    public static interface ReconnectionAttemptListener {
        public void onReconnecting(ServiceEvent var1);
    }

    @FunctionalInterface
    public static interface ReconnectionListener {
        public void onReconnected(ServiceEvent var1);
    }

    @ProviderType
    public static interface RequestReplyMessagingService {
        public RequestReplyMessageReceiverBuilder createRequestReplyMessageReceiverBuilder();

        public RequestReplyMessagePublisherBuilder createRequestReplyMessagePublisherBuilder();
    }
}

