/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config;

import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface RetryStrategy {
    public int getRetries();

    public int getRetryInterval();

    public static RetryStrategy foreverRetry() {
        return new RetryStrategyImpl(-1, 3000);
    }

    public static RetryStrategy foreverRetry(int retryInterval) {
        if (retryInterval < 0 || retryInterval > 60000) {
            throw new IllegalArgumentException("Retry interval is out of range [0-60000]");
        }
        return new RetryStrategyImpl(-1, retryInterval);
    }

    public static RetryStrategy neverRetry() {
        return new RetryStrategyImpl(0, 3000);
    }

    public static RetryStrategy parametrizedRetry(int retries, int retryInterval) {
        if (retries < 0) {
            throw new IllegalArgumentException("Number of retries should not be negative");
        }
        if (retryInterval < 0 || retryInterval > 60000) {
            throw new IllegalArgumentException("Retry interval is out of range [0-60000]");
        }
        return new RetryStrategyImpl(retries, retryInterval);
    }

    @Internal
    @ProviderType
    public static class RetryStrategyImpl
    implements RetryStrategy {
        private final int retries;
        private final int retryInterval;

        private RetryStrategyImpl(int retries, int retryInterval) {
            this.retries = retries;
            this.retryInterval = retryInterval;
        }

        @Override
        public int getRetries() {
            return this.retries;
        }

        @Override
        public int getRetryInterval() {
            return this.retryInterval;
        }

        public String toString() {
            return "RetryStrategyImpl{retries=" + this.retries + ", retryInterval=" + this.retryInterval + '}';
        }
    }

    @Internal
    @ProviderType
    public static class RetryConfigurationProvider {
        public static TypedConfiguration toReconnectionConfiguration(final RetryStrategy strategy) {
            TypedConfiguration configuration = new TypedConfiguration(){

                @Override
                public TypedProperties getConfiguration() {
                    TypedProperties.TypedPropertiesImpl retryConfiguration = new TypedProperties.TypedPropertiesImpl();
                    retryConfiguration.setIntegerProperty("ClientChannelProperties_ReconnectRetries", strategy.getRetries());
                    retryConfiguration.setIntegerProperty("ClientChannelProperties_ReconnectRetryWaitInMillis", strategy.getRetryInterval());
                    return retryConfiguration;
                }
            };
            return configuration;
        }

        public static TypedConfiguration toConnectionConfiguration(final RetryStrategy strategy) {
            TypedConfiguration configuration = new TypedConfiguration(){

                @Override
                public TypedProperties getConfiguration() {
                    TypedProperties.TypedPropertiesImpl retryConfiguration = new TypedProperties.TypedPropertiesImpl();
                    retryConfiguration.setIntegerProperty("ClientChannelProperties_ConnectRetries", strategy.getRetries());
                    retryConfiguration.setIntegerProperty("ClientChannelProperties_ReconnectRetryWaitInMillis", strategy.getRetryInterval());
                    return retryConfiguration;
                }
            };
            return configuration;
        }
    }
}

