/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.publisher;

import com.solace.messaging.MessagingService;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.publisher.PersistentMessagePublisher;
import com.solace.messaging.publisher.PublisherBuffers;
import com.solace.messaging.publisher.PublisherHealthCheck;
import com.solace.messaging.resources.Topic;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.LifecycleControl;
import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.ManageablePublisher;
import com.solace.messaging.util.PublisherCongestionNotificationDispatcher;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.async.DiscardOldestConcurrentBuffer;
import com.solace.messaging.util.async.ExtendedCompletableFuture;
import com.solace.messaging.util.async.ThreadFactories;
import com.solace.messaging.util.async.ToggleLatch;
import com.solace.messaging.util.internal.BiTask;
import com.solace.messaging.util.internal.ClientSession;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Task;
import com.solace.messaging.util.internal.TerminationEventImpl;
import com.solace.messaging.util.internal.TerminationNotificationDispatcher;
import com.solace.messaging.util.internal.TriTask;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.ProducerEventArgs;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class PersistentMessagePublisherImpl
implements PersistentMessagePublisher {
    private volatile JCSMPXMLMessageProducer producer;
    private final MessagingServiceInternalView serviceInternalView;
    private final TypedProperties publisherConfiguration;
    private final OutboundMessageBuilder messageBuilder;
    private final long id;
    private final String instanceName;
    private final MessagingService.ServiceInterruptionListener serviceInterruptionListener;
    private final ClientSession.ClientSessionStateListener closedSessionListener;
    private final JCSMPStreamingPublishCorrelatingEventHandler messageCorrelationHandler;
    private final JCSMPProducerEventHandler publisherEventHandler;
    private final PublisherNotificationDispatcher notificationDispatcher;
    private final PublisherBuffers.PublisherBuffer<Topic> buffer;
    private final DiscardOldestConcurrentBuffer<Long> inFlightMessageIdBuffer;
    private final MessageCorrelationKeyProvider messageKeyProvider;
    private final ExecutorService publisherBotExecutorService;
    private volatile boolean gracefulShutdownInProgress = false;
    final AtomicInteger stateHolder = new AtomicInteger(0);
    private final Task<PersistentMessagePublisherImpl> postTerminationClearBufferSilentTask;
    private final Consumer<PublisherBuffers.Publishable<Topic>> bufferCleaningAction;
    private final ManageablePublisher.PersistentPublisherInfo publisherInfo;
    private final TerminationNotificationDispatcher terminationNotificationDispatcher;
    private final PublisherCongestionNotificationDispatcher bufferCongestionNotificationDispatcher;
    static final int STATE_NOT_STARTED = 0;
    static final int STATE_STARTED = 1;
    static final int STATE_TERMINATED = 2;
    private static final AtomicLong instanceIdGenerator = new AtomicLong(0L);
    private static final Log logger = LogFactory.getLog(PersistentMessagePublisherImpl.class);
    private static final TriTask<PersistentMessagePublisherImpl, Long, AtomicInteger> postTerminationTerminateAsyncTask = (publisher, gracePeriod, lostMessages) -> {
        long deadlineNano = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos((long)gracePeriod);
        try {
            boolean publisherBufferEmpty = publisher.buffer.awaitEmpty((long)gracePeriod, TimeUnit.MILLISECONDS);
            long remainingGracePeriodNano = deadlineNano - System.nanoTime();
            if (remainingGracePeriodNano <= 0L) {
                publisher.gracefulShutdownInProgress = false;
                if (!publisherBufferEmpty || !publisher.inFlightMessageIdBuffer.isEmpty()) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(publisher.instanceName + " gracefully terminated before all buffered messages were processed, not sufficient grace period of " + gracePeriod));
                    }
                    lostMessages.set(publisher.buffer.size() + publisher.inFlightMessageIdBuffer.size());
                }
            } else {
                boolean inFlightMessageIdBufferEmpty = publisher.inFlightMessageIdBuffer.awaitEmpty(remainingGracePeriodNano, TimeUnit.NANOSECONDS);
                publisher.gracefulShutdownInProgress = false;
                if (!publisherBufferEmpty || !inFlightMessageIdBufferEmpty) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(publisher.instanceName + " gracefully terminated before all all broker acks/nacks were received, not sufficient grace period of " + gracePeriod));
                    }
                    lostMessages.set(publisher.buffer.size() + publisher.inFlightMessageIdBuffer.size());
                }
            }
        }
        catch (PubSubPlusClientException.RequestInterruptedException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Graceful termination of " + publisher.instanceName + " was interrupted"));
            }
        }
        finally {
            publisher.gracefulShutdownInProgress = false;
            publisher.emptyBuffer(publisher.buffer, publisher.inFlightMessageIdBuffer);
            try {
                if (publisher.producer != null) {
                    publisher.producer.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Problem with closing underlying IO after termination of " + publisher.instanceName), (Throwable)e);
            }
            if (!publisher.publisherBotExecutorService.isShutdown()) {
                try {
                    publisher.publisherBotExecutorService.shutdown();
                }
                catch (Exception e) {
                    logger.warn((Object)("Problem with shutdown of executor service after termination of " + publisher.instanceName), (Throwable)e);
                }
            }
        }
    };
    private static final BiTask<PersistentMessagePublisherImpl, AtomicInteger> postTerminateNowTask = (publisher, lostMessages) -> {
        block12: {
            block11: {
                block10: {
                    try {
                        int bufferSize = publisher.buffer.size() + publisher.inFlightMessageIdBuffer.size();
                        boolean bufferEmpty = bufferSize < 1;
                        publisher.emptyBuffer(publisher.buffer, publisher.inFlightMessageIdBuffer);
                        if (!bufferEmpty) {
                            lostMessages.set(bufferSize);
                            publisher.serviceInternalView.getApiMetricsCollector().increaseMetric(Manageable.ApiMetrics.Metric.PUBLISH_MESSAGES_TERMINATION_DISCARDED, bufferSize);
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)(publisher.instanceName + " non-gracefully terminated before all buffered messages were processed."));
                            }
                        }
                    }
                    catch (PubSubPlusClientException.RequestInterruptedException e) {
                        if (!logger.isWarnEnabled()) break block10;
                        logger.warn((Object)("Non-graceful termination of " + publisher.instanceName + " was interrupted"));
                    }
                }
                try {
                    if (publisher.producer != null) {
                        publisher.producer.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!logger.isWarnEnabled()) break block11;
                    logger.warn((Object)("Problem closing underlying IO during termination of " + publisher.instanceName), (Throwable)e);
                }
            }
            if (!publisher.publisherBotExecutorService.isShutdown()) {
                try {
                    publisher.publisherBotExecutorService.shutdown();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block12;
                    logger.warn((Object)("Problem shutting down executor service during termination of " + publisher.instanceName), (Throwable)e);
                }
            }
        }
    };

    public PersistentMessagePublisherImpl(MessagingServiceInternalView serviceInternalView, TypedProperties publisherConfiguration, OutboundMessageBuilder messageBuilder) {
        this.id = instanceIdGenerator.incrementAndGet();
        this.instanceName = "PersistentMessagePublisher@" + this.id;
        this.publisherInfo = new PersistentPublisherInfoImpl();
        this.publisherBotExecutorService = Executors.newSingleThreadExecutor(new ThreadFactories.NamedDaemonThreadFactory(this.instanceName + "-message-dispatcher"));
        this.serviceInternalView = serviceInternalView;
        this.publisherConfiguration = publisherConfiguration;
        this.buffer = PublisherBuffers.createBuffer(this.publisherConfiguration, this.serviceInternalView.getApiMetricsCollector());
        this.inFlightMessageIdBuffer = this.createInFlightMessageIdBuffer(this.publisherConfiguration);
        this.messageBuilder = this.configureMessageBuilder(messageBuilder);
        this.messageKeyProvider = new MessageCorrelationKeyProvider();
        this.terminationNotificationDispatcher = new TerminationNotificationDispatcher();
        this.serviceInterruptionListener = new MessagingService.ServiceInterruptionListener(){

            @Override
            public void onServiceInterrupted(MessagingService.ServiceEvent e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Shutting down publisher due to Service interruption");
                }
                if (PersistentMessagePublisherImpl.this.stateHolder.getAndSet(2) < 2) {
                    PersistentMessagePublisherImpl.this.terminationNotificationDispatcher.onTermination(new TerminationEventImpl(e.getTimestamp(), e.getMessage(), e.getCause()));
                    PersistentMessagePublisherImpl.this.onTerminate(null, PersistentMessagePublisherImpl.this.postTerminationClearBufferSilentTask);
                }
            }
        };
        this.closedSessionListener = new ClientSession.ClientSessionStateListener(){

            @Override
            public void onClientSessionStateChange(ClientSession.ClientSessionStateChangeEvent event) {
                if (logger.isWarnEnabled()) {
                    logger.info((Object)"Shutting down publisher due to service closure");
                }
                if (PersistentMessagePublisherImpl.this.stateHolder.getAndSet(2) < 2) {
                    PersistentMessagePublisherImpl.this.terminationNotificationDispatcher.onTermination(new TerminationEventImpl(event.getTimestamp(), event.getMessage(), event.getCause()));
                    PersistentMessagePublisherImpl.this.onTerminate(null, PersistentMessagePublisherImpl.this.postTerminationClearBufferSilentTask);
                }
            }
        };
        this.notificationDispatcher = new PublisherNotificationDispatcher();
        this.messageCorrelationHandler = new JCSMPStreamingPublishCorrelatingEventHandler(){

            public void handleError(String s, JCSMPException e, long l) {
            }

            public void responseReceived(String s) {
            }

            public void responseReceivedEx(Object o) {
                if (PersistentMessagePublisherImpl.this.isRunning() || PersistentMessagePublisherImpl.this.gracefulShutdownInProgress) {
                    PersistentMessagePublisherImpl.this.notificationDispatcher.onDeliveryConfirmation(o);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)(PersistentMessagePublisherImpl.this.instanceName + " received 'ack' message response from a broker after termination"));
                }
            }

            public void handleErrorEx(Object o, JCSMPException e, long l) {
                if (PersistentMessagePublisherImpl.this.isRunning() || PersistentMessagePublisherImpl.this.gracefulShutdownInProgress) {
                    PersistentMessagePublisherImpl.this.notificationDispatcher.onException(o, (Exception)((Object)e), l);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)(PersistentMessagePublisherImpl.this.instanceName + " received 'nack' message response from a broker after termination"), (Throwable)e);
                }
            }
        };
        this.publisherEventHandler = new JCSMPProducerEventHandler(){

            public void handleEvent(ProducerEventArgs producerEventArgs) {
            }
        };
        this.bufferCleaningAction = publishable -> {
            OutboundMessage m = publishable.getMessage();
            this.notificationDispatcher.onException(m.getCorrelationKey(), new IllegalStateException("Message publisher is already terminated"), Instant.now().toEpochMilli());
        };
        this.postTerminationClearBufferSilentTask = publisher -> {
            long lostMessages;
            block6: {
                lostMessages = publisher.buffer.size() + publisher.inFlightMessageIdBuffer.size();
                try {
                    publisher.buffer.close(this.bufferCleaningAction);
                }
                catch (PubSubPlusClientException.RequestInterruptedException e) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn((Object)("Non-graceful termination of " + publisher.instanceName + " was interrupted"));
                }
            }
            publisher.inFlightMessageIdBuffer.clear();
            publisher.serviceInternalView.getApiMetricsCollector().increaseMetric(Manageable.ApiMetrics.Metric.PUBLISH_MESSAGES_TERMINATION_DISCARDED, lostMessages);
            if (!this.publisherBotExecutorService.isShutdown()) {
                this.publisherBotExecutorService.shutdown();
            }
            try {
                if (this.producer != null && !this.producer.isClosed()) {
                    this.producer.close();
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("Problem with closing underlying IO after termination of " + this.instanceName), (Throwable)ex);
            }
        };
        this.bufferCongestionNotificationDispatcher = new PublisherCongestionNotificationDispatcher(this);
        this.buffer.setBufferCongestionMonitor(this.bufferCongestionNotificationDispatcher, 1);
    }

    @Override
    public boolean isRunning() {
        return 1 == this.stateHolder.get();
    }

    @Override
    public boolean isTerminated() {
        return 2 == this.stateHolder.get();
    }

    @Override
    public boolean isTerminating() {
        return this.gracefulShutdownInProgress;
    }

    @Override
    public void setTerminationNotificationListener(LifecycleControl.TerminationNotificationListener listener) {
        this.terminationNotificationDispatcher.setTerminationNotificationListener(listener);
    }

    @Override
    public void setMessagePublishReceiptListener(PersistentMessagePublisher.MessagePublishReceiptListener listener) {
        this.notificationDispatcher.setMessageDeliveryListener(listener);
    }

    @Override
    public void publish(byte[] message, Topic destination) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.publish(message, destination, null);
    }

    @Override
    public void publish(byte[] message, Topic destination, Object userContext) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.validatePublisher();
        Validation.nullIllegal(message, "Message array can't be null");
        Validation.nullIllegal(destination, "Message destination can't be null");
        OutboundMessage outboundMessage = this.messageBuilder.build(message);
        this.publishInternalMessage(outboundMessage, destination, null, userContext);
    }

    @Override
    public void publish(String message, Topic destination) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.publish(message, destination, null);
    }

    @Override
    public void publish(String message, Topic destination, Object userContext) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.validatePublisher();
        Validation.nullIllegal(message, "Message string can't be null");
        Validation.nullIllegal(destination, "Message destination can't be null");
        OutboundMessage outboundMessage = this.messageBuilder.build(message);
        this.publishInternalMessage(outboundMessage, destination, null, userContext);
    }

    @Override
    public void publish(OutboundMessage message, Topic destination) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.publish(message, destination, null, null);
    }

    @Override
    public void publish(OutboundMessage message, Topic destination, Object userContext) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.publish(message, destination, userContext, null);
    }

    @Override
    public void publish(OutboundMessage message, Topic destination, Object userContext, Properties additionalMessageProperties) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException {
        this.validatePublisher();
        Validation.nullIllegal(message, "Message can't be null");
        Validation.nullIllegal(destination, "Message destination can't be null");
        this.publishExternalMessage(message, destination, additionalMessageProperties, userContext);
    }

    @Override
    public void publishAwaitAcknowledgement(OutboundMessage message, Topic destination, long timeout) throws PubSubPlusClientException.TimeoutException, PubSubPlusClientException.MessageRejectedByBrokerException, PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.MessageDestinationDoesNotExistException, PubSubPlusClientException.MessageNotAcknowledgedByBrokerException, PubSubPlusClientException, InterruptedException {
        this.publishAwaitAcknowledgement(message, destination, timeout, null);
    }

    @Override
    public void publishAwaitAcknowledgement(OutboundMessage message, Topic destination, long timeout, Properties additionalMessageProperties) throws PubSubPlusClientException.TimeoutException, PubSubPlusClientException.MessageRejectedByBrokerException, PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.MessageDestinationDoesNotExistException, PubSubPlusClientException.MessageNotAcknowledgedByBrokerException, PubSubPlusClientException, InterruptedException {
        this.validatePublisher();
        Validation.nullIllegal(message, "Message can't be null");
        Validation.nullIllegal(destination, "Message destination can't be null");
        this.publishBlockingExternalMessage(message, destination, additionalMessageProperties, timeout, true);
    }

    @Override
    public <PersistentMessagePublisher> CompletableFuture<PersistentMessagePublisher> startAsync() throws PubSubPlusClientException {
        ExtendedCompletableFuture<PersistentMessagePublisherImpl> onStart;
        boolean started;
        if (!this.serviceInternalView.isConnected()) {
            throw new IllegalStateException("Publisher can't be started before it is connected to a messaging service");
        }
        int state = this.stateHolder.get();
        if (state == 2) {
            throw new IllegalStateException("Message publisher is already terminated");
        }
        do {
            boolean terminated;
            onStart = new ExtendedCompletableFuture<PersistentMessagePublisherImpl>();
            boolean bl = terminated = 2 == this.stateHolder.get();
            if (terminated) {
                return ExtendedCompletableFuture.failedFuture(new IllegalStateException("Publisher is already terminated"));
            }
            boolean starting = this.stateHolder.compareAndSet(0, 1);
            if (!starting) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " is being started"));
            }
            try {
                this.onStart();
                onStart.complete(this);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.instanceName + " is started"));
                }
            }
            catch (Exception e) {
                logger.error((Object)(this.instanceName + " failed to start and is terminating"), (Throwable)e);
                this.onTerminate(null, this.postTerminationClearBufferSilentTask);
                onStart.completeExceptionally(new IllegalStateException("Publisher is already closed due to internal error"));
            }
            return ExtendedCompletableFuture.onCancellation(onStart, (service, throwable) -> {
                this.stateHolder.set(2);
                this.onTerminate(null, this.postTerminationClearBufferSilentTask);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.instanceName + " async start was canceled"));
                }
            });
        } while (!(started = 1 == this.stateHolder.get()));
        onStart.complete(this);
        return onStart;
    }

    @Override
    public CompletableFuture<Void> terminateAsync(long gracePeriod) throws PubSubPlusClientException, IllegalStateException {
        Validation.smallerThanNumbersIllegal(1L, gracePeriod, "Grace period < 1");
        Task<PersistentMessagePublisherImpl> preTerminationTask = publisher -> {
            publisher.stateHolder.set(2);
            publisher.gracefulShutdownInProgress = true;
        };
        AtomicInteger lostMessages = new AtomicInteger(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is being terminated"));
        }
        this.onTerminate(preTerminationTask, postTerminationTerminateAsyncTask, gracePeriod, lostMessages);
        ExtendedCompletableFuture<Void> term = new ExtendedCompletableFuture<Void>();
        int lm = lostMessages.get();
        if (lm > 0) {
            this.serviceInternalView.getApiMetricsCollector().increaseMetric(Manageable.ApiMetrics.Metric.PUBLISH_MESSAGES_TERMINATION_DISCARDED, lm);
            term.completeExceptionally(new PubSubPlusClientException.IncompleteMessageDeliveryException(String.format("Delivery of %d messages could not be completed due to expiration of a grace period", lm), lm));
        } else {
            term.complete(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is terminated"));
        }
        return term;
    }

    @Override
    public void terminateAsync(CompletionListener<Void> terminationListener, long gracePeriod) throws PubSubPlusClientException, IllegalStateException {
        Validation.nullIllegal(terminationListener, "Termination listener can't be null");
        CompletableFuture<Void> onceDisconnected = this.terminateAsync(gracePeriod);
        onceDisconnected.whenComplete((nothing, throwable) -> {
            block2: {
                try {
                    terminationListener.onCompletion(null, throwable == null ? null : throwable.getCause());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing async termination completion notification", (Throwable)e);
                }
            }
        });
    }

    @Override
    public <PersistentMessagePublisher> void startAsync(CompletionListener<PersistentMessagePublisher> startListener) throws PubSubPlusClientException, IllegalStateException {
        Validation.nullIllegal(startListener, "Start listener can't be null");
        CompletableFuture<PersistentMessagePublisher> onceConnected = this.startAsync();
        onceConnected.whenComplete((publisher, throwable) -> {
            block2: {
                try {
                    startListener.onCompletion(publisher, throwable == null ? null : throwable.getCause());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing async start completion notification", (Throwable)e);
                }
            }
        });
    }

    @Override
    public ManageablePublisher.PersistentPublisherInfo publisherInfo() {
        return this.publisherInfo;
    }

    @Override
    public PersistentMessagePublisher start() {
        if (1 == this.stateHolder.get()) {
            return this;
        }
        try {
            this.startAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (t instanceof PubSubPlusClientException) {
                    throw (PubSubPlusClientException)t;
                }
                if (t instanceof IllegalStateException) {
                    throw (IllegalStateException)t;
                }
                throw new PubSubPlusClientException(t);
            }
            if (logger.isErrorEnabled()) {
                logger.error((Object)(this.instanceName + " failed to start"));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Publisher start was canceled", e);
        }
        catch (CancellationException e) {
            throw new PubSubPlusClientException.RequestInterruptedException("Publisher start was canceled", e);
        }
        return this;
    }

    @Override
    public void terminate(long gracePeriod) throws PubSubPlusClientException {
        if (gracePeriod == 0L) {
            this.terminateNow();
            return;
        }
        try {
            this.terminateAsync(gracePeriod).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (t instanceof PubSubPlusClientException) {
                    throw (PubSubPlusClientException)t;
                }
                if (t instanceof IllegalStateException) {
                    throw (IllegalStateException)t;
                }
                throw new PubSubPlusClientException(t);
            }
            throw new PubSubPlusClientException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Publisher termination was canceled", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void terminateNow() throws PubSubPlusClientException.IncompleteMessageDeliveryException, PubSubPlusClientException, IllegalStateException {
        int lm;
        AtomicInteger lostMessages = new AtomicInteger(0);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " is being non gracefully terminated"));
            }
            this.onTerminate(null, postTerminateNowTask, lostMessages);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " is terminated"));
            }
            if ((lm = lostMessages.get()) <= 0) return;
        }
        catch (Throwable throwable) {
            int lm2 = lostMessages.get();
            if (lm2 <= 0) throw throwable;
            throw new PubSubPlusClientException.IncompleteMessageDeliveryException(String.format("Delivery of %d messages could not be completed due to non graceful termination", lm2), lm2);
        }
        throw new PubSubPlusClientException.IncompleteMessageDeliveryException(String.format("Delivery of %d messages could not be completed due to non graceful termination", lm), lm);
    }

    @Override
    public boolean isReady() {
        return this.isRunning() && this.buffer.remainingCapacity() > 0 && !this.gracefulShutdownInProgress;
    }

    @Override
    public void setPublisherReadinessListener(PublisherHealthCheck.PublisherReadinessListener listener) {
        this.bufferCongestionNotificationDispatcher.setPublisherReadinessListener(listener);
    }

    @Override
    public void notifyWhenReady() {
        this.bufferCongestionNotificationDispatcher.notifyWhenReady();
    }

    @Internal
    void publishExternalMessage(OutboundMessage userSuppliedMessage, Topic destination, Properties additionalMessageProperties, Object userContextObject) {
        OutboundMessage outboundMessage = additionalMessageProperties == null || additionalMessageProperties.isEmpty() ? OutboundMessageBuilder.deepCopy(userSuppliedMessage) : OutboundMessageBuilder.deepCopy(userSuppliedMessage, additionalMessageProperties);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectDeliveryMode(outboundMessage, DeliveryMode.PERSISTENT);
        CorrelationContext messageContext = new CorrelationContext(this.messageKeyProvider.nextLongKey(), userContextObject, outboundMessage);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectCorrelationKey(outboundMessage, messageContext);
        this.buffer.insert(PublisherBuffers.Publishable.of(outboundMessage, destination));
    }

    @Internal
    void publishInternalMessage(OutboundMessage apiCreatedMessage, Topic destination, Properties additionalMessageProperties, Object userContextObject) {
        OutboundMessage outboundMessage = additionalMessageProperties == null || additionalMessageProperties.isEmpty() ? apiCreatedMessage : OutboundMessageBuilder.OutboundMessageBuilderImpl.injectExtendedMessageProperties(apiCreatedMessage, additionalMessageProperties);
        CorrelationContext messageContext = new CorrelationContext(this.messageKeyProvider.nextLongKey(), userContextObject, outboundMessage);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectCorrelationKey(outboundMessage, messageContext);
        this.buffer.insert(PublisherBuffers.Publishable.of(outboundMessage, destination));
    }

    @Internal
    void publishBlockingExternalMessage(OutboundMessage userSuppliedMessage, Topic destination, Properties additionalMessageProperties, long timeout, boolean ackImmediately) {
        OutboundMessage outboundMessage = additionalMessageProperties == null || additionalMessageProperties.isEmpty() ? OutboundMessageBuilder.deepCopy(userSuppliedMessage) : OutboundMessageBuilder.deepCopy(userSuppliedMessage, additionalMessageProperties);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectDeliveryMode(outboundMessage, DeliveryMode.PERSISTENT);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectAckImmediately(outboundMessage, ackImmediately);
        BlockingCorrelationContext messageContext = new BlockingCorrelationContext(this.messageKeyProvider.nextLongKey(), null, outboundMessage);
        OutboundMessageBuilder.OutboundMessageBuilderImpl.injectCorrelationKey(outboundMessage, messageContext);
        this.buffer.insert(PublisherBuffers.Publishable.of(outboundMessage, destination));
        try {
            messageContext.locker.lock();
            boolean onTime = messageContext.locker.await(timeout, TimeUnit.MILLISECONDS);
            if (!onTime) {
                throw new PubSubPlusClientException.TimeoutException(String.format("Message was not acknowledged within %d milliseconds", timeout));
            }
            PubSubPlusClientException couldBeThrown = messageContext.getException();
            if (couldBeThrown != null) {
                throw couldBeThrown;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Blocking publish was interrupted", e);
        }
        finally {
            messageContext.clear();
        }
    }

    void validatePublisher() {
        if (this.isTerminating() || this.isTerminated()) {
            throw new IllegalStateException("Message publisher was terminated");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Message publisher not running");
        }
    }

    OutboundMessageBuilder configureMessageBuilder(OutboundMessageBuilder messageBuilder) {
        if (messageBuilder instanceof OutboundMessageBuilder.OutboundMessageBuilderImpl) {
            OutboundMessageBuilder.OutboundMessageBuilderImpl mBuilder = (OutboundMessageBuilder.OutboundMessageBuilderImpl)messageBuilder;
            mBuilder.forPersistentMessagePublisher();
        }
        return messageBuilder;
    }

    void onStart() throws PubSubPlusClientException {
        this.serviceInternalView.getClientSession().addServiceInterruptionListener(this.serviceInterruptionListener);
        this.serviceInternalView.getClientSession().addClientSessionStateListener(this.closedSessionListener);
        this.producer = this.createMessageProducer(this.messageCorrelationHandler, this.publisherEventHandler, this.publisherConfiguration);
        this.publisherBotExecutorService.submit(() -> {
            JCSMPXMLMessageProducer prOptimized = this.producer;
            while ((this.isRunning() || this.gracefulShutdownInProgress) && !this.buffer.isClosed()) {
                if (prOptimized != null) {
                    if (!prOptimized.isClosed()) {
                        PublisherBuffers.Publishable<Topic> nextMessageTask = this.buffer.consume();
                        if (nextMessageTask != null) {
                            Object correlationObject = nextMessageTask.getMessage().getCorrelationKey();
                            if (correlationObject instanceof CorrelationContext && correlationObject != null) {
                                this.inFlightMessageIdBuffer.add(((CorrelationContext)correlationObject).getCorrelationKey());
                            }
                            try {
                                prOptimized.send((XMLMessage)OutboundMessageBuilder.OutboundMessageBuilderImpl.OutboundMessageImpl.toByteMessage(nextMessageTask.getMessage()), (Destination)nextMessageTask.getDestination());
                            }
                            catch (Exception e) {
                                this.serviceInternalView.getClientSession().getSessionStats().incStat(StatType.MESSAGES_DISCARDED_INTERNAL);
                                if (correlationObject instanceof CorrelationContext) {
                                    this.inFlightMessageIdBuffer.remove(((CorrelationContext)correlationObject).getCorrelationKey());
                                }
                                if (e instanceof ClosedFacilityException && this.gracefulShutdownInProgress) break;
                                if (logger.isErrorEnabled()) {
                                    logger.error((Object)(this.instanceName + " could not publish message to a broker. Message:" + nextMessageTask.getMessage() + ", destination: " + nextMessageTask.getDestination()), (Throwable)e);
                                }
                                prOptimized = this.producer;
                                this.notificationDispatcher.onException(nextMessageTask.getMessage().getCorrelationKey(), e, Instant.now().toEpochMilli());
                            }
                            continue;
                        }
                        if (!this.buffer.isClosed()) continue;
                        break;
                    }
                    if (this.gracefulShutdownInProgress) break;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    prOptimized = this.producer;
                    continue;
                }
                if (!logger.isErrorEnabled()) break;
                this.onTerminate(null, null);
                logger.error((Object)(this.instanceName + " could not create an internal service to publish messages to a broker."));
                break;
            }
        });
    }

    void onTerminate(Task<PersistentMessagePublisherImpl> preTerminationTask, Task<PersistentMessagePublisherImpl> postTerminationTask) {
        try {
            if (preTerminationTask != null) {
                preTerminationTask.run(this);
            }
            this.stateHolder.set(2);
            this.serviceInternalView.getClientSession().removeServiceInterruptionListener(this.serviceInterruptionListener);
            this.serviceInternalView.getClientSession().removeClientSessionStateListener(this.closedSessionListener);
            this.buffer.setBufferCongestionMonitor(null, -1);
            this.bufferCongestionNotificationDispatcher.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " publisher is shutdown"));
            }
        }
        finally {
            this.terminationNotificationDispatcher.close();
            if (postTerminationTask != null) {
                postTerminationTask.run(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <P2> void onTerminate(Task<PersistentMessagePublisherImpl> preTerminationTask, BiTask<PersistentMessagePublisherImpl, P2> postTerminationTask, P2 p2) {
        try {
            if (preTerminationTask != null) {
                preTerminationTask.run(this);
            }
            this.stateHolder.set(2);
            this.serviceInternalView.getClientSession().removeServiceInterruptionListener(this.serviceInterruptionListener);
            this.serviceInternalView.getClientSession().removeClientSessionStateListener(this.closedSessionListener);
            this.buffer.setBufferCongestionMonitor(null, -1);
            this.bufferCongestionNotificationDispatcher.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " publisher is shutdown"));
            }
        }
        finally {
            this.terminationNotificationDispatcher.close();
            if (postTerminationTask != null) {
                postTerminationTask.run(this, p2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <P2, P3> void onTerminate(Task<PersistentMessagePublisherImpl> preTerminationTask, TriTask<PersistentMessagePublisherImpl, P2, P3> postTerminationTask, P2 p2, P3 p3) {
        try {
            if (preTerminationTask != null) {
                preTerminationTask.run(this);
            }
            this.stateHolder.set(2);
            this.serviceInternalView.getClientSession().removeServiceInterruptionListener(this.serviceInterruptionListener);
            this.serviceInternalView.getClientSession().removeClientSessionStateListener(this.closedSessionListener);
            this.buffer.setBufferCongestionMonitor(null, -1);
            this.bufferCongestionNotificationDispatcher.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " publisher is shutdown"));
            }
        }
        finally {
            this.terminationNotificationDispatcher.close();
            if (postTerminationTask != null) {
                postTerminationTask.run(this, p2, p3);
            }
        }
    }

    DiscardOldestConcurrentBuffer<Long> createInFlightMessageIdBuffer(TypedProperties publisherConfiguration) {
        int windowSize = 255;
        return new DiscardOldestConcurrentBuffer<Long>(windowSize);
    }

    JCSMPXMLMessageProducer createMessageProducer(JCSMPStreamingPublishCorrelatingEventHandler messageCorrelationHandler, JCSMPProducerEventHandler publisherEventHandler, TypedProperties publisherConfiguration) throws PubSubPlusClientException {
        try {
            ClientSession clientSession = this.serviceInternalView.getClientSession();
            if (clientSession.getDefaultProducer() == null) {
                clientSession.getMessageProducer((JCSMPStreamingPublishEventHandler)new JCSMPStreamingPublishCorrelatingEventHandler(){

                    public void responseReceivedEx(Object key) {
                        logger.error((Object)("DefaultProducer should not be log response received for key" + key));
                    }

                    public void handleErrorEx(Object key, JCSMPException cause, long timestamp) {
                        logger.error((Object)("DefaultProducer should not be log:" + key), (Throwable)cause);
                    }

                    public void handleError(String s, JCSMPException e, long l) {
                        logger.error((Object)("DefaultProducer should not be log:" + s), (Throwable)e);
                    }

                    public void responseReceived(String s) {
                        logger.error((Object)("DefaultProducer should not be log response received for key" + s));
                    }
                }, new JCSMPProducerEventHandler(){

                    public void handleEvent(ProducerEventArgs producerEventArgs) {
                        logger.error((Object)("DefaultProducer should not log response received for key " + producerEventArgs));
                    }
                });
            }
            return (JCSMPXMLMessageProducer)clientSession.createProducer(this.toFlowProperties(publisherConfiguration), (JCSMPStreamingPublishEventHandler)messageCorrelationHandler, publisherEventHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PubSubPlusClientException("Failed to create message publisher", e);
        }
    }

    ProducerFlowProperties toFlowProperties(TypedProperties publisherConfiguration) {
        String ackEventMode;
        Boolean routerAckWindowed;
        Integer windowSize;
        Boolean multithreaded;
        Boolean expirationCalculated;
        Boolean seqNumberGenerated;
        Boolean timestampGenerated;
        Boolean senderIdGenerated;
        ProducerFlowProperties flowProperties = new ProducerFlowProperties();
        Integer pubAckTime = publisherConfiguration.getIntegerProperty("pub_ack_time");
        if (pubAckTime != null) {
            flowProperties.setPubAckTime(pubAckTime);
        }
        if ((senderIdGenerated = publisherConfiguration.getBooleanProperty("generate_sender_id")) != null) {
            flowProperties.setGenerateSenderId(senderIdGenerated);
        }
        if ((timestampGenerated = publisherConfiguration.getBooleanProperty("generate_send_timestamps")) != null) {
            flowProperties.setGenerateSendTimeStamp(timestampGenerated);
        }
        if ((seqNumberGenerated = publisherConfiguration.getBooleanProperty("generate_sequence_numbers")) != null) {
            flowProperties.setGenerateSequenceNumber(seqNumberGenerated);
        }
        if ((expirationCalculated = publisherConfiguration.getBooleanProperty("calculate_message_expiration")) != null) {
            flowProperties.setCalculateMessageExpiration(expirationCalculated);
        }
        if ((multithreaded = publisherConfiguration.getBooleanProperty("pub_multi_thread")) != null) {
            flowProperties.setPubMultiThreaded(multithreaded);
        }
        if ((windowSize = publisherConfiguration.getIntegerProperty("pub_ack_window_size")) != null) {
            flowProperties.setWindowSize(windowSize.intValue());
        }
        if ((routerAckWindowed = publisherConfiguration.getBooleanProperty("ad_pub_router_windowed_ack")) != null) {
            flowProperties.setRtrWindowedAck(routerAckWindowed.booleanValue());
        }
        if ((ackEventMode = publisherConfiguration.getProperty("ACK_EVENT_MODE")) != null) {
            flowProperties.setAckEventMode(ackEventMode);
        }
        return flowProperties;
    }

    void emptyBuffer(PublisherBuffers.PublisherBuffer<Topic> buffer, DiscardOldestConcurrentBuffer<Long> inFlightMessageIdBuffer) {
        block2: {
            try {
                buffer.close(this.bufferCleaningAction);
            }
            catch (PubSubPlusClientException.RequestInterruptedException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)("Non-graceful termination of " + this.instanceName + " was interrupted"));
            }
        }
        inFlightMessageIdBuffer.clear();
    }

    @Internal
    @ProviderType
    private class PublisherNotificationDispatcher {
        private volatile PersistentMessagePublisher.MessagePublishReceiptListener messageDeliveryListener;

        private PublisherNotificationDispatcher() {
        }

        public void onDeliveryConfirmation(Object correlationObject) {
            if (correlationObject == null) {
                return;
            }
            if (correlationObject instanceof BlockingCorrelationContext) {
                this.handleSyncDeliveryConfirmation((BlockingCorrelationContext)correlationObject);
            } else if (correlationObject instanceof CorrelationContext) {
                this.handleAsyncDeliveryConfirmation((CorrelationContext)correlationObject);
            } else {
                logger.error((Object)(PersistentMessagePublisherImpl.this.instanceName + "received unknown type of message correlation object with message acknowledgement: " + correlationObject));
            }
        }

        public void onException(Object correlationObject, Exception e, long timeStampMilliSeconds) {
            if (e == null || correlationObject == null) {
                return;
            }
            PubSubPlusClientException mappedEx = this.mapException(e);
            if (correlationObject instanceof BlockingCorrelationContext) {
                this.handleSyncDeliveryError((BlockingCorrelationContext)correlationObject, mappedEx);
            } else if (correlationObject instanceof CorrelationContext) {
                this.handleAsyncDeliveryError((CorrelationContext)correlationObject, mappedEx, timeStampMilliSeconds);
            } else {
                logger.error((Object)(PersistentMessagePublisherImpl.this.instanceName + "received unknown type of message correlation object with message acknowledgement: " + correlationObject));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleAsyncDeliveryConfirmation(CorrelationContext correlationContext) {
            this.cleanInFlightMessageIdBuffer(correlationContext);
            PersistentMessagePublisher.MessagePublishReceiptListener l = this.messageDeliveryListener;
            if (l == null) {
                return;
            }
            try {
                l.onPublishReceipt(new PersistentMessagePublisher.PublishReceipt(correlationContext.getLinkedMessage(), null, Instant.now().toEpochMilli(), true, correlationContext.getUserContext()));
            }
            catch (Exception e) {
                logger.error((Object)"Application code throw an unhandled exception by processing of Publish Receipt notification", (Throwable)e);
            }
            finally {
                correlationContext.clear();
            }
        }

        void handleSyncDeliveryConfirmation(BlockingCorrelationContext blockingCorrelationContext) {
            this.cleanInFlightMessageIdBuffer(blockingCorrelationContext);
            blockingCorrelationContext.locker.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleAsyncDeliveryError(CorrelationContext correlationContext, PubSubPlusClientException ex, long timeStampMilliSeconds) {
            this.cleanInFlightMessageIdBuffer(correlationContext);
            PersistentMessagePublisher.MessagePublishReceiptListener l = this.messageDeliveryListener;
            if (l == null) {
                return;
            }
            try {
                l.onPublishReceipt(new PersistentMessagePublisher.PublishReceipt(correlationContext.getLinkedMessage(), ex, timeStampMilliSeconds, false, correlationContext.getUserContext()));
            }
            catch (Exception e) {
                logger.error((Object)"Application code throw an unhandled exception by processing of Publish Receipt notification", (Throwable)e);
            }
            finally {
                correlationContext.clear();
            }
        }

        void handleSyncDeliveryError(BlockingCorrelationContext blockingCorrelationContext, PubSubPlusClientException e) {
            this.cleanInFlightMessageIdBuffer(blockingCorrelationContext);
            blockingCorrelationContext.setException(e);
            blockingCorrelationContext.locker.open();
        }

        void cleanInFlightMessageIdBuffer(CorrelationContext correlationContext) {
            Long correlationKey = correlationContext.getCorrelationKey();
            PersistentMessagePublisherImpl.this.inFlightMessageIdBuffer.remove(correlationKey);
        }

        void setMessageDeliveryListener(PersistentMessagePublisher.MessagePublishReceiptListener messageDeliveryListener) {
            this.messageDeliveryListener = messageDeliveryListener;
        }

        PubSubPlusClientException mapException(Exception e) {
            if (e instanceof PubSubPlusClientException) {
                return (PubSubPlusClientException)e;
            }
            return new PubSubPlusClientException(e);
        }
    }

    @ProviderType
    private class PersistentPublisherInfoImpl
    implements ManageablePublisher.PersistentPublisherInfo {
        private PersistentPublisherInfoImpl() {
        }

        @Override
        public long getId() {
            return PersistentMessagePublisherImpl.this.id;
        }

        @Override
        public String getInstanceName() {
            return PersistentMessagePublisherImpl.this.instanceName;
        }
    }

    @ProviderType
    static class BlockingCorrelationContext
    extends CorrelationContext {
        private static final long serialVersionUID = -7494601208708091659L;
        private volatile ToggleLatch locker = new ToggleLatch();

        BlockingCorrelationContext(Long correlationKey, Object userContext, OutboundMessage message) {
            super(correlationKey, userContext, message);
        }

        public boolean lock(long waitDuration, TimeUnit timeUnit) throws InterruptedException {
            if (this.locker != null) {
                ToggleLatch l = this.locker;
                if (l != null) {
                    l.lock();
                    return l.await(waitDuration, timeUnit);
                }
                throw new IllegalStateException("Thread can't be locked after context is cleared");
            }
            throw new IllegalStateException("Thread can't be locked after context is cleared");
        }

        public void unlock() {
            ToggleLatch l;
            if (this.locker != null && (l = this.locker) != null) {
                l.open();
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.locker.open();
            this.locker = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockingCorrelationContext)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    @Internal
    @ProviderType
    static class CorrelationContext
    implements Serializable {
        private static final long serialVersionUID = 426395239935681793L;
        private final Long correlationKey;
        private volatile Object userContext;
        private volatile PubSubPlusClientException exception;
        private volatile OutboundMessage linkedMessage;

        CorrelationContext(Long correlationKey, Object userContext, OutboundMessage message) {
            this.correlationKey = correlationKey;
            this.userContext = userContext;
            this.linkedMessage = message;
        }

        public Long getCorrelationKey() {
            return this.correlationKey;
        }

        public Object getUserContext() {
            return this.userContext;
        }

        public PubSubPlusClientException getException() {
            return this.exception;
        }

        public void setException(PubSubPlusClientException exception) {
            this.exception = exception;
        }

        public OutboundMessage getLinkedMessage() {
            return this.linkedMessage;
        }

        public void clear() {
            this.linkedMessage = null;
            this.exception = null;
            this.userContext = null;
            this.userContext = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CorrelationContext context = (CorrelationContext)o;
            return this.correlationKey != null ? this.correlationKey.equals(context.correlationKey) : context.correlationKey == null;
        }

        public int hashCode() {
            return this.correlationKey != null ? this.correlationKey.hashCode() : 0;
        }
    }

    @ProviderType
    static class MessageCorrelationKeyProvider
    implements Serializable {
        final AtomicLong messageKeyProvider = new AtomicLong(ThreadLocalRandom.current().nextLong(1L, 1000L));

        MessageCorrelationKeyProvider() {
        }

        Long nextLongKey() {
            return this.messageKeyProvider.incrementAndGet();
        }
    }

    @ProviderType
    static class PropertyConfiguration
    extends JCSMPProperties {
        private static final long serialVersionUID = 7052052844320400643L;

        PropertyConfiguration(Map<String, Object> defaults) {
            super(defaults);
        }
    }
}

