/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.resources.TopicSubscription;
import com.solace.messaging.util.internal.Internal;
import com.solacesystems.jcsmp.JCSMPResponseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface AsyncReceiverSubscriptions {
    public void addSubscriptionAsync(TopicSubscription var1, SubscriptionChangeListener var2) throws PubSubPlusClientException;

    public void removeSubscriptionAsync(TopicSubscription var1, SubscriptionChangeListener var2) throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class AddSubscriptionListenerAdapter
    implements JCSMPResponseListener {
        private static final Log logger = LogFactory.getLog(AddSubscriptionListenerAdapter.class);
        private final SubscriptionChangeListener listener;
        final TopicSubscription subscription;

        AddSubscriptionListenerAdapter(SubscriptionChangeListener listener, TopicSubscription subscription) {
            this.listener = listener;
            this.subscription = subscription;
        }

        public void handleSuccess(Object key) {
            block2: {
                try {
                    this.listener.onSubscriptionChange(this.subscription, SubscriptionChangeListener.SubscriptionOperation.ADDED, null);
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)("Application code throw an unhandled exception by processing 'subscription added' notification: " + this.subscription), (Throwable)e);
                }
            }
        }

        public void handleError(Object key, Exception cause) {
            block2: {
                try {
                    this.listener.onSubscriptionChange(this.subscription, SubscriptionChangeListener.SubscriptionOperation.ADDED, new PubSubPlusClientException(cause));
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)("Application code throw an unhandled exception by processing failed 'subscription added' notification: " + this.subscription), (Throwable)e);
                }
            }
        }
    }

    @Internal
    @ProviderType
    public static class RemoveSubscriptionListenerAdapter
    implements JCSMPResponseListener {
        private final SubscriptionChangeListener listener;
        final TopicSubscription subscription;
        private static final Log logger = LogFactory.getLog(RemoveSubscriptionListenerAdapter.class);

        RemoveSubscriptionListenerAdapter(SubscriptionChangeListener listener, TopicSubscription subscription) {
            this.listener = listener;
            this.subscription = subscription;
        }

        public void handleSuccess(Object key) {
            block2: {
                try {
                    this.listener.onSubscriptionChange(this.subscription, SubscriptionChangeListener.SubscriptionOperation.REMOVED, null);
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)("Application code throw an unhandled exception by processing 'remove subscription' notification: " + this.subscription), (Throwable)e);
                }
            }
        }

        public void handleError(Object key, Exception cause) {
            block2: {
                try {
                    this.listener.onSubscriptionChange(this.subscription, SubscriptionChangeListener.SubscriptionOperation.REMOVED, new PubSubPlusClientException(cause));
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)("Application code throw an unhandled exception by processing failed 'remove subscription' notification: " + this.subscription), (Throwable)e);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface SubscriptionChangeListener {
        public void onSubscriptionChange(TopicSubscription var1, SubscriptionOperation var2, PubSubPlusClientException var3);

        public static enum SubscriptionOperation {
            ADDED,
            REMOVED;

        }
    }
}

