/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.resources;

import com.solace.messaging.resources.Destination;
import com.solace.messaging.resources.ResourceAccessibility;
import com.solace.messaging.resources.ResourceDurability;
import com.solace.messaging.util.internal.Internal;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Queue
extends Destination,
ResourceDurability,
ResourceAccessibility {
    public static Queue durableExclusiveQueue(String queueName) {
        return new Queues.SimpleDurableQueue(queueName, true);
    }

    public static Queue durableNonExclusiveQueue(String queueName) {
        return new Queues.SimpleDurableQueue(queueName, false);
    }

    public static Queue nonDurableExclusiveQueue(String queueName) {
        return new Queues.SimpleNonDurableQueue(queueName, true);
    }

    public static Queue nonDurableExclusiveQueue() {
        return new Queues.SimpleNonDurableQueue(null, true);
    }

    @ProviderType
    public static final class Queues {
        private Queues() {
        }

        @Internal
        @ProviderType
        static interface NonDurableQueue
        extends Queue {
            @Override
            default public boolean isDurable() {
                return false;
            }
        }

        @Internal
        @ProviderType
        static interface DurableQueue
        extends Queue {
            @Override
            default public boolean isDurable() {
                return true;
            }
        }

        @Internal
        @ProviderType
        static final class SimpleNonDurableQueue
        implements NonDurableQueue {
            private static final long serialVersionUID = 3302738783945509139L;
            private final String name;
            private final boolean exclusivelyAccessible;

            private SimpleNonDurableQueue(String name, boolean exclusivelyAccessible) {
                this.name = name;
                this.exclusivelyAccessible = exclusivelyAccessible;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isExclusivelyAccessible() {
                return this.exclusivelyAccessible;
            }

            public String toString() {
                return "SimpleNonDurableQueue{name='" + this.name + '\'' + ", exclusivelyAccessible=" + this.exclusivelyAccessible + '}';
            }
        }

        @Internal
        @ProviderType
        static final class SimpleDurableQueue
        implements DurableQueue {
            private static final long serialVersionUID = -4432806688042655066L;
            private final String name;
            private final boolean exclusivelyAccessible;

            private SimpleDurableQueue(String name, boolean exclusivelyAccessible) {
                this.name = name;
                this.exclusivelyAccessible = exclusivelyAccessible;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isExclusivelyAccessible() {
                return this.exclusivelyAccessible;
            }

            public String toString() {
                return "SimpleDurableQueue{name='" + this.name + '\'' + ", exclusivelyAccessible=" + this.exclusivelyAccessible + '}';
            }
        }
    }
}

