/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util;

import com.solace.messaging.util.internal.Internal;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface TypedProperties
extends Serializable {
    public String getProperty(String var1);

    public Object setProperty(String var1, String var2);

    public Integer getIntegerProperty(String var1);

    public Integer setIntegerProperty(String var1, Integer var2);

    public Long getLongProperty(String var1);

    public Long setLongProperty(String var1, Long var2);

    public Boolean getBooleanProperty(String var1);

    public Boolean setBooleanProperty(String var1, Boolean var2);

    public boolean containsProperty(String var1);

    public Set<String> propertyNames();

    public Object getObjectProperty(String var1);

    public Object setObjectProperty(String var1, Object var2);

    public Map<String, Object> toUnmodifiableMap();

    public Object remove(String var1);

    @Internal
    @ProviderType
    public static class ConfigurationProperties
    implements Serializable {
        final TypedProperties typedProperties;
        final Properties untypedProperties;

        public ConfigurationProperties(TypedProperties typedProperties, Properties untypedProperties) {
            this.typedProperties = typedProperties;
            this.untypedProperties = untypedProperties;
        }

        public TypedProperties getTypedProperties() {
            return this.typedProperties;
        }

        public Properties getUntypedProperties() {
            return this.untypedProperties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationProperties that = (ConfigurationProperties)o;
            if (this.typedProperties != null ? !this.typedProperties.equals(that.typedProperties) : that.typedProperties != null) {
                return false;
            }
            return this.untypedProperties != null ? this.untypedProperties.equals(that.untypedProperties) : that.untypedProperties == null;
        }

        public int hashCode() {
            int result = this.typedProperties != null ? this.typedProperties.hashCode() : 0;
            result = 31 * result + (this.untypedProperties != null ? this.untypedProperties.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ConfigurationProperties{typedProperties=" + this.typedProperties + ", untypedProperties=" + this.untypedProperties + '}';
        }
    }

    @Internal
    @ProviderType
    public static class TypedPropertiesImpl
    implements TypedProperties {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        @Override
        public String getProperty(String name) {
            return (String)this.properties.get(name);
        }

        @Override
        public Object setProperty(String name, String value) {
            return this.properties.put(name, value);
        }

        @Override
        public Integer getIntegerProperty(String name) {
            return (Integer)this.properties.get(name);
        }

        @Override
        public Integer setIntegerProperty(String name, Integer value) {
            return (Integer)this.properties.put(name, value);
        }

        @Override
        public Long getLongProperty(String name) {
            return (Long)this.properties.get(name);
        }

        @Override
        public Long setLongProperty(String name, Long value) {
            return (Long)this.properties.put(name, value);
        }

        @Override
        public Boolean getBooleanProperty(String name) {
            return (Boolean)this.properties.get(name);
        }

        @Override
        public Boolean setBooleanProperty(String name, Boolean value) {
            return (Boolean)this.properties.put(name, value);
        }

        @Override
        public boolean containsProperty(String key) {
            return this.properties.containsKey(key);
        }

        @Override
        public Set<String> propertyNames() {
            return this.properties.keySet();
        }

        @Override
        public Object getObjectProperty(String name) {
            return this.properties.get(name);
        }

        @Override
        public Object setObjectProperty(String name, Object value) {
            return this.properties.put(name, value);
        }

        @Override
        public Object remove(String key) {
            return this.properties.remove(key);
        }

        @Override
        public Map<String, Object> toUnmodifiableMap() {
            return Collections.unmodifiableMap(this.properties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedPropertiesImpl that = (TypedPropertiesImpl)o;
            return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
        }

        public int hashCode() {
            return this.properties != null ? this.properties.hashCode() : 0;
        }

        public String toString() {
            return "TypedPropertiesImpl{properties=" + this.properties + '}';
        }
    }
}

