/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.async;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.util.internal.Internal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ExecutableMessageHandler
implements MessageReceiver.MessageHandler {
    private final MessageReceiver.MessageHandler messageHandler;
    private final ExecutorService executorService;
    private final Log logger;
    private final String parentId;

    public ExecutableMessageHandler(MessageReceiver.MessageHandler messageHandler, ExecutorService executorService, Log logger, String parentId) {
        this.messageHandler = messageHandler;
        this.executorService = executorService;
        this.logger = logger;
        this.parentId = parentId;
    }

    @Override
    public void onMessage(InboundMessage message) {
        if (this.executorService == null) {
            this.messageHandler.onMessage(message);
        } else {
            try {
                this.executorService.submit(() -> {
                    block2: {
                        try {
                            this.messageHandler.onMessage(message);
                        }
                        catch (Exception e) {
                            if (!this.logger.isErrorEnabled()) break block2;
                            this.logger.error((Object)("Application code throw an unhandled exception by message processing: " + message), (Throwable)e);
                        }
                    }
                    return null;
                });
            }
            catch (RejectedExecutionException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)(this.parentId + " could not schedule message async processing"), (Throwable)e);
                }
                throw new PubSubPlusClientException("Provided Executor service rejected message delivery scheduling", e);
            }
        }
    }
}

