/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.content;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.fest.assertions.api.android.util.BitMaskStringBuilder;

public class IntentAssert
extends AbstractAssert<IntentAssert, Intent> {
    public IntentAssert(Intent actual) {
        super((Object)actual, IntentAssert.class);
    }

    public IntentAssert hasAction(String action) {
        this.isNotNull();
        String actualAction = ((Intent)this.actual).getAction();
        ((StringAssert)Assertions.assertThat((String)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>.", new Object[]{action, actualAction})).isEqualTo((Object)action);
        return this;
    }

    public IntentAssert hasType(String type) {
        this.isNotNull();
        String actualType = ((Intent)this.actual).getType();
        ((StringAssert)Assertions.assertThat((String)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo((Object)type);
        return this;
    }

    public IntentAssert hasExtra(String name) {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Intent)this.actual).hasExtra(name)).overridingErrorMessage("Expected extra <%s> to be present but was not present.", new Object[]{name})).isTrue();
        return this;
    }

    public IntentAssert hasFlags(int flags) {
        int expected = ((Intent)this.actual).getFlags();
        ((IntegerAssert)Assertions.assertThat((int)expected).overridingErrorMessage("Expected <%s> but was <%s>.", new Object[]{IntentAssert.flagsToString(expected), IntentAssert.flagsToString(flags)})).isEqualTo(flags);
        return this;
    }

    public IntentAssert hasData(String uri) {
        return this.hasData(Uri.parse((String)uri));
    }

    public IntentAssert hasData(Uri uri) {
        Uri actualUri = ((Intent)this.actual).getData();
        ((IntegerAssert)Assertions.assertThat((int)actualUri.compareTo(uri)).overridingErrorMessage("Expected data Uri <%s> but was <%s>.", new Object[]{uri, actualUri})).isEqualTo(0);
        return this;
    }

    public IntentAssert hasComponent(ComponentName expected) {
        ComponentName componentName = ((Intent)this.actual).getComponent();
        ((ObjectAssert)Assertions.assertThat((Object)componentName).overridingErrorMessage("Expected component name <%s> but was <%s>.", new Object[]{expected.flattenToString(), componentName.flattenToString()})).isEqualTo((Object)expected);
        return this;
    }

    public IntentAssert hasComponent(Context context, Class<?> cls) {
        return this.hasComponent(new ComponentName(context, cls.getName()));
    }

    public IntentAssert hasComponent(String appPkg, Class<?> cls) {
        return this.hasComponent(new ComponentName(appPkg, cls.getName()));
    }

    public static String flagsToString(int flags) {
        return new BitMaskStringBuilder(flags).flag(1, "grant_read_uri_permission").flag(2, "grant_write_uri_permission").flag(8, "debug_log_resolution").flag(4, "from_background").flag(0x400000, "activity_brought_to_front").flag(32768, "activity_clear_task").flag(0x4000000, "activity_clear_top").flag(524288, "activity_clear_when_task_reset").flag(0x800000, "activity_exclude_from_recents").flag(0x2000000, "activity_forward_result").flag(0x100000, "activity_launched_from_history").flag(0x8000000, "activity_multiple_task").flag(0x10000000, "activity_new_task").flag(65536, "activity_no_animation").flag(0x40000000, "activity_no_history").flag(0x40000000, "receiver_registered_only").flag(262144, "activity_no_user_action").flag(0x1000000, "activity_previous_is_top").flag(0x200000, "activity_reset_task_if").flag(131072, "activity_reorder_to_front").flag(0x20000000, "activity_single_top").flag(16384, "activity_task_on_home").get();
    }
}

