/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.gesture;

import android.gesture.GestureOverlayView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class GestureOverlayViewAssert
extends AbstractFrameLayoutAssert<GestureOverlayViewAssert, GestureOverlayView> {
    public GestureOverlayViewAssert(GestureOverlayView actual) {
        super(actual, GestureOverlayViewAssert.class);
    }

    public GestureOverlayViewAssert hasFadeOffset(long offset) {
        this.isNotNull();
        long actualOffset = ((GestureOverlayView)this.actual).getFadeOffset();
        ((LongAssert)Assertions.assertThat((long)actualOffset).overridingErrorMessage("Expected fade offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public GestureOverlayViewAssert hasGestureColor(int color) {
        this.isNotNull();
        int actualColor = ((GestureOverlayView)this.actual).getGestureColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected gesture color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeAngleThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeAngleThreshold();
        ((FloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke angle threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeLengthThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeLengthThreshold();
        ((FloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke length threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeSquarenessThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeSquarenessTreshold();
        ((FloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke squareness threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStokeType(int type) {
        this.isNotNull();
        int actualType = ((GestureOverlayView)this.actual).getGestureStrokeType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected gesture stroke type <%s> but was <%s>.", new Object[]{GestureOverlayViewAssert.gestureStrokeTypeToString(type), GestureOverlayViewAssert.gestureStrokeTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeWidth(float width) {
        this.isNotNull();
        float actualWidth = ((GestureOverlayView)this.actual).getGestureStrokeWidth();
        ((FloatAssert)Assertions.assertThat((float)actualWidth).overridingErrorMessage("Expected gesture stroke width <%s> but was <%s>.", new Object[]{Float.valueOf(width), Float.valueOf(actualWidth)})).isEqualTo(width);
        return this;
    }

    public GestureOverlayViewAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((GestureOverlayView)this.actual).getOrientation();
        ((IntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{GestureOverlayViewAssert.orientationToString(orientation), GestureOverlayViewAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return this;
    }

    public GestureOverlayViewAssert hasUncertainGestureColor(int color) {
        this.isNotNull();
        int actualColor = ((GestureOverlayView)this.actual).getUncertainGestureColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected uncertain gesture color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public GestureOverlayViewAssert isInterceptingEvents() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isEventsInterceptionEnabled()).overridingErrorMessage("Expected to be intercepting events but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isNotInterceptingEvents() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isEventsInterceptionEnabled()).overridingErrorMessage("Expected to not be intercepting events but was.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isFadeEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isFadeEnabled()).overridingErrorMessage("Expected to have fade enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isFadeDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isFadeEnabled()).overridingErrorMessage("Expected to have fade disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isGestureVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGestureVisible()).overridingErrorMessage("Expected gesture to be visible but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isGestureNotVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGestureVisible()).overridingErrorMessage("Expected gesture to not be visible but was.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isGesturing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGesturing()).overridingErrorMessage("Expected to be gesturing but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isNotGesturing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGesturing()).overridingErrorMessage("Expected to not be gesturing but was.", new Object[0])).isFalse();
        return this;
    }

    private static String gestureStrokeTypeToString(int type) {
        switch (type) {
            case 0: {
                return "single";
            }
            case 1: {
                return "multiple";
            }
        }
        throw new IllegalArgumentException("Unknown gesture stroke type: " + type);
    }

    private static String orientationToString(int orientation) {
        switch (orientation) {
            case 0: {
                return "horizontal";
            }
            case 1: {
                return "vertical";
            }
        }
        throw new IllegalArgumentException("Unknown orientation: " + orientation);
    }
}

