/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.RectF;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;

public class RectFAssert
extends AbstractAssert<RectFAssert, RectF> {
    public RectFAssert(RectF actual) {
        super((Object)actual, RectFAssert.class);
    }

    public RectFAssert hasBottom(float bottom) {
        this.isNotNull();
        float actualBottom = ((RectF)this.actual).bottom;
        ((FloatAssert)Assertions.assertThat((float)actualBottom).overridingErrorMessage("Expected bottom <%s> but was <%s>.", new Object[]{Float.valueOf(bottom), Float.valueOf(actualBottom)})).isEqualTo(bottom);
        return this;
    }

    public RectFAssert hasLeft(float left) {
        this.isNotNull();
        float actualLeft = ((RectF)this.actual).left;
        ((FloatAssert)Assertions.assertThat((float)actualLeft).overridingErrorMessage("Expected left <%s> but was <%s>.", new Object[]{Float.valueOf(left), Float.valueOf(actualLeft)})).isEqualTo(left);
        return this;
    }

    public RectFAssert hasRight(float right) {
        this.isNotNull();
        float actualRight = ((RectF)this.actual).right;
        ((FloatAssert)Assertions.assertThat((float)actualRight).overridingErrorMessage("Expected right <%s> but was <%s>.", new Object[]{Float.valueOf(right), Float.valueOf(actualRight)})).isEqualTo(right);
        return this;
    }

    public RectFAssert hasTop(float top) {
        this.isNotNull();
        float actualTop = ((RectF)this.actual).top;
        ((FloatAssert)Assertions.assertThat((float)actualTop).overridingErrorMessage("Expected top <%s> but was <%s>.", new Object[]{Float.valueOf(top), Float.valueOf(actualTop)})).isEqualTo(top);
        return this;
    }

    public RectFAssert hasCenterX(float center) {
        this.isNotNull();
        float actualCenter = ((RectF)this.actual).centerX();
        ((FloatAssert)Assertions.assertThat((float)actualCenter).overridingErrorMessage("Expected X center <%s> but was <%s>.", new Object[]{Float.valueOf(center), Float.valueOf(actualCenter)})).isEqualTo(center);
        return this;
    }

    public RectFAssert hasCenterY(float center) {
        this.isNotNull();
        float actualCenter = ((RectF)this.actual).centerY();
        ((FloatAssert)Assertions.assertThat((float)actualCenter).overridingErrorMessage("Expected Y center <%s> but was <%s>.", new Object[]{Float.valueOf(center), Float.valueOf(actualCenter)})).isEqualTo(center);
        return this;
    }

    public RectFAssert hasHeight(float height) {
        this.isNotNull();
        float actualHeight = ((RectF)this.actual).height();
        ((FloatAssert)Assertions.assertThat((float)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{Float.valueOf(height), Float.valueOf(actualHeight)})).isEqualTo(height);
        return this;
    }

    public RectFAssert isEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RectF)this.actual).isEmpty()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isTrue();
        return this;
    }

    public RectFAssert isNotEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RectF)this.actual).isEmpty()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isFalse();
        return this;
    }

    public RectFAssert hasWidth(float width) {
        this.isNotNull();
        float actualWidth = ((RectF)this.actual).width();
        ((FloatAssert)Assertions.assertThat((float)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{Float.valueOf(width), Float.valueOf(actualWidth)})).isEqualTo(width);
        return this;
    }
}

