/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;

public abstract class AbstractPreferenceAssert<S extends AbstractPreferenceAssert<S, A>, A extends Preference>
extends AbstractAssert<S, A> {
    protected AbstractPreferenceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasContext(Context context) {
        this.isNotNull();
        Context actualContext = ((Preference)this.actual).getContext();
        ((ObjectAssert)Assertions.assertThat((Object)actualContext).overridingErrorMessage("Expected context <%s> but was <%s>.", new Object[]{context, actualContext})).isSameAs((Object)context);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasDependency(String dependency) {
        this.isNotNull();
        String actualDependency = ((Preference)this.actual).getDependency();
        ((StringAssert)Assertions.assertThat((String)actualDependency).overridingErrorMessage("Expected dependency <%s> but was <%s>.", new Object[]{dependency, actualDependency})).isEqualTo((Object)dependency);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasFragment(String fragment) {
        this.isNotNull();
        String actualFragment = ((Preference)this.actual).getFragment();
        ((StringAssert)Assertions.assertThat((String)actualFragment).overridingErrorMessage("Expected fragment <%s> but was <%s>.", new Object[]{fragment, actualFragment})).isEqualTo((Object)fragment);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((Preference)this.actual).getIcon();
        ((ObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasIntent(Intent intent) {
        this.isNotNull();
        Intent actualIntent = ((Preference)this.actual).getIntent();
        ((ObjectAssert)Assertions.assertThat((Object)actualIntent).overridingErrorMessage("Expected intent <%s> but was <%s>.", new Object[]{intent, actualIntent})).isEqualTo((Object)intent);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasKey(String key) {
        this.isNotNull();
        String actualKey = ((Preference)this.actual).getKey();
        ((StringAssert)Assertions.assertThat((String)actualKey).overridingErrorMessage("Expected key <%s> but was <%s>.", new Object[]{key, actualKey})).isEqualTo((Object)key);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getLayoutResource();
        ((IntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected layout resource ID <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceChangeListener(Preference.OnPreferenceChangeListener listener) {
        this.isNotNull();
        Preference.OnPreferenceChangeListener actualListener = ((Preference)this.actual).getOnPreferenceChangeListener();
        ((ObjectAssert)Assertions.assertThat((Object)actualListener).overridingErrorMessage("Expected preference change listener <%s> but was <%s>.", new Object[]{listener, actualListener})).isSameAs((Object)listener);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceClickListener(Preference.OnPreferenceClickListener listener) {
        this.isNotNull();
        Preference.OnPreferenceClickListener actualListener = ((Preference)this.actual).getOnPreferenceClickListener();
        ((ObjectAssert)Assertions.assertThat((Object)actualListener).overridingErrorMessage("Expected preference click listener <%s> but was <%s>.", new Object[]{listener, actualListener})).isSameAs((Object)listener);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((Preference)this.actual).getOrder();
        ((IntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceManager(PreferenceManager manager) {
        this.isNotNull();
        PreferenceManager actualManager = ((Preference)this.actual).getPreferenceManager();
        ((ObjectAssert)Assertions.assertThat((Object)actualManager).overridingErrorMessage("Expected preference manager <%s> but was <%s>.", new Object[]{manager, actualManager})).isSameAs((Object)manager);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSharedPreferences(SharedPreferences preferences) {
        this.isNotNull();
        SharedPreferences actualPreferences = ((Preference)this.actual).getSharedPreferences();
        ((ObjectAssert)Assertions.assertThat((Object)actualPreferences).overridingErrorMessage("Expected shared preferences <%s> but was <%s>.", new Object[]{preferences, actualPreferences})).isSameAs((Object)preferences);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSummary(CharSequence summary) {
        this.isNotNull();
        CharSequence actualSummary = ((Preference)this.actual).getSummary();
        ((ObjectAssert)Assertions.assertThat((Object)actualSummary).overridingErrorMessage("Expected summary <%s> but was <%s>.", new Object[]{summary, actualSummary})).isEqualTo((Object)summary);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSummary(int resId) {
        this.isNotNull();
        return this.hasSummary(((Preference)this.actual).getContext().getString(resId));
    }

    public S hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((Preference)this.actual).getTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasTitle(int resId) {
        this.isNotNull();
        return this.hasTitle(((Preference)this.actual).getContext().getString(resId));
    }

    public S hasTitleResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getTitleRes();
        ((IntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected title resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasWidgetLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getWidgetLayoutResource();
        ((IntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected widget layout resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasKey() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).hasKey()).overridingErrorMessage("Expected to have valid key but was invalid.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isPersistent() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isPersistent()).overridingErrorMessage("Expected to be persistent but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isNotPersistent() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isPersistent()).overridingErrorMessage("Expected to not be persistent but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isSelectable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isSelectable()).overridingErrorMessage("Expected to be selectable but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isNotSelectable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isSelectable()).overridingErrorMessage("Expected to not be selectable but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }
}

