/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.util;

import android.util.Property;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;

public class PropertyAssert<T, V>
extends AbstractAssert<PropertyAssert<T, V>, Property<T, V>> {
    public PropertyAssert(Property<T, V> actual) {
        super(actual, PropertyAssert.class);
    }

    public PropertyAssert<T, V> hasName(String name) {
        this.isNotNull();
        String actualName = ((Property)this.actual).getName();
        ((StringAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public PropertyAssert<T, V> hasType(Class<?> type) {
        this.isNotNull();
        Class actualType = ((Property)this.actual).getType();
        ((ObjectAssert)Assertions.assertThat((Object)actualType).overridingErrorMessage("Expected type <%s> but was <%s>", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    public PropertyAssert<T, V> isReadOnly() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Property)this.actual).isReadOnly()).overridingErrorMessage("Expected read only but was not read only.", new Object[0])).isTrue();
        return this;
    }

    public PropertyAssert<T, V> isNotReadOnly() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Property)this.actual).isReadOnly()).overridingErrorMessage("Expected not read only but was read only.", new Object[0])).isFalse();
        return this;
    }
}

