/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.View;
import android.view.Window;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.ObjectAssert;

public class WindowAssert
extends AbstractAssert<WindowAssert, Window> {
    public WindowAssert(Window actual) {
        super((Object)actual, WindowAssert.class);
    }

    public WindowAssert hasCurrentFocus(View view) {
        this.isNotNull();
        View actualView = ((Window)this.actual).getCurrentFocus();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected current focused view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public WindowAssert hasChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasChildren()).overridingErrorMessage("Expected children but had no children.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert hasNoChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasChildren()).overridingErrorMessage("Expected no children but had children.", new Object[0])).isFalse();
        return this;
    }

    public WindowAssert hasFeature(int feature) {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasFeature(feature)).overridingErrorMessage("Expected feature <%s> but was not present.", new Object[]{WindowAssert.featureToString(feature)})).isTrue();
        return this;
    }

    public WindowAssert isActive() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isActive()).overridingErrorMessage("Expected to be active but was not active.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert isNotActive() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isActive()).overridingErrorMessage("Expected to not be active but was active.", new Object[0])).isFalse();
        return this;
    }

    public WindowAssert isFloating() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isFloating()).overridingErrorMessage("Expected to be floating but was not floating.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert isNotFloating() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isFloating()).overridingErrorMessage("Expected to not be floating but was floating.", new Object[0])).isFalse();
        return this;
    }

    public static String featureToString(int feature) {
        switch (feature) {
            case 8: {
                return "actionBar";
            }
            case 9: {
                return "actionBarOverlay";
            }
            case 10: {
                return "actionModeOverlay";
            }
            case 6: {
                return "contextMenu";
            }
            case 7: {
                return "customTitle";
            }
            case 5: {
                return "indeterminateProgress";
            }
            case 3: {
                return "leftIcon";
            }
            case 1: {
                return "noIcon";
            }
            case 0: {
                return "optionsPanel";
            }
            case 2: {
                return "progress";
            }
            case 4: {
                return "rightIcon";
            }
        }
        throw new IllegalArgumentException("Unknown window feature: " + feature);
    }
}

