/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.view.View;
import android.widget.TabHost;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class TabHostAssert
extends AbstractFrameLayoutAssert<TabHostAssert, TabHost> {
    public TabHostAssert(TabHost actual) {
        super(actual, TabHostAssert.class);
    }

    public TabHostAssert hasCurrentTab(int tab) {
        this.isNotNull();
        int actualTab = ((TabHost)this.actual).getCurrentTab();
        ((IntegerAssert)Assertions.assertThat((int)actualTab).overridingErrorMessage("Expected current tab <%s> but was <%s>.", new Object[]{tab, actualTab})).isEqualTo(tab);
        return this;
    }

    public TabHostAssert hasCurrentTabTag(String tag) {
        this.isNotNull();
        String actualTag = ((TabHost)this.actual).getCurrentTabTag();
        ((StringAssert)Assertions.assertThat((String)actualTag).overridingErrorMessage("Expected current tab tag <%s> but was <%s>.", new Object[]{tag, actualTag})).isEqualTo((Object)tag);
        return this;
    }

    public TabHostAssert hasCurrentTabView(View view) {
        this.isNotNull();
        View actualView = ((TabHost)this.actual).getCurrentTabView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected current tab view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public TabHostAssert hasCurrentView(View view) {
        this.isNotNull();
        View actualView = ((TabHost)this.actual).getCurrentView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected current view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }
}

