/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.TimePicker;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class TimePickerAssert
extends AbstractFrameLayoutAssert<TimePickerAssert, TimePicker> {
    public TimePickerAssert(TimePicker actual) {
        super(actual, TimePickerAssert.class);
    }

    public TimePickerAssert hasCurrentHour(Integer hour) {
        this.isNotNull();
        Integer actualHour = ((TimePicker)this.actual).getCurrentHour();
        ((IntegerAssert)Assertions.assertThat((Integer)actualHour).overridingErrorMessage("Expected current hour <%s> but was <%s>.", new Object[]{hour, actualHour})).isEqualTo((Object)hour);
        return this;
    }

    public TimePickerAssert hasCurrentMinute(Integer minute) {
        this.isNotNull();
        Integer actualMinute = ((TimePicker)this.actual).getCurrentMinute();
        ((IntegerAssert)Assertions.assertThat((Integer)actualMinute).overridingErrorMessage("Expected current minute <%s> but was <%s>.", new Object[]{minute, actualMinute})).isEqualTo((Object)minute);
        return this;
    }

    public TimePickerAssert isIn24HourView() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TimePicker)this.actual).is24HourView()).overridingErrorMessage("Expected to be in 24 hour view but was not.", new Object[0])).isTrue();
        return this;
    }

    public TimePickerAssert isNotIn24HourView() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TimePicker)this.actual).is24HourView()).overridingErrorMessage("Expected to not be in 24 hour view but was.", new Object[0])).isFalse();
        return this;
    }
}

