/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006 "}, d2={"Lokhttp3/logging/HttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "(Lokhttp3/logging/HttpLoggingInterceptor$Logger;)V", "headersToRedact", "", "", "<set-?>", "Lokhttp3/logging/HttpLoggingInterceptor$Level;", "level", "getLevel", "()Lokhttp3/logging/HttpLoggingInterceptor$Level;", "-deprecated_setLevel", "(Lokhttp3/logging/HttpLoggingInterceptor$Level;)V", "-deprecated_getLevel", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logHeader", "", "headers", "Lokhttp3/Headers;", "i", "", "redactHeader", "name", "setLevel", "Companion", "Level", "Logger", "okhttp-logging-interceptor"})
public final class HttpLoggingInterceptor
implements Interceptor {
    private volatile Set<String> headersToRedact;
    @NotNull
    private volatile Level level;
    private final Logger logger;
    private static final Charset UTF8;
    public static final Companion Companion;

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @JvmName(name="-deprecated_setLevel")
    public final void -deprecated_setLevel(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"<set-?>");
        this.level = level;
    }

    public final void redactHeader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        TreeSet<String> newHeadersToRedact = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        newHeadersToRedact.addAll((Collection)this.headersToRedact);
        newHeadersToRedact.add(name);
        this.headersToRedact = newHeadersToRedact;
    }

    @NotNull
    public final HttpLoggingInterceptor setLevel(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        HttpLoggingInterceptor httpLoggingInterceptor = this;
        boolean bl = false;
        boolean bl2 = false;
        HttpLoggingInterceptor $this$apply = httpLoggingInterceptor;
        boolean bl3 = false;
        $this$apply.level = level;
        return httpLoggingInterceptor;
    }

    @JvmName(name="-deprecated_getLevel")
    @NotNull
    public final Level -deprecated_getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        int n;
        String string;
        ResponseBody responseBody;
        long contentLength;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = "--> " + request.method() + ' ' + request.url() + (connection != null ? " " + connection.protocol() : "");
        if (!logHeaders && requestBody != null) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.log(requestStartMessage);
        if (logHeaders) {
            if (requestBody != null) {
                MediaType mediaType = requestBody.contentType();
                if (mediaType != null) {
                    MediaType mediaType2 = mediaType;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaType it = mediaType2;
                    boolean bl3 = false;
                    this.logger.log("Content-Type: " + it);
                }
                if (requestBody.contentLength() != -1L) {
                    this.logger.log("Content-Length: " + requestBody.contentLength());
                }
            }
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                String name = headers.name(i);
                if (StringsKt.equals((String)"Content-Type", (String)name, (boolean)true) || StringsKt.equals((String)"Content-Length", (String)name, (boolean)true)) continue;
                this.logHeader(headers, i);
            }
            if (!logBody || requestBody == null) {
                this.logger.log("--> END " + request.method());
            } else if (HttpLoggingInterceptor.Companion.bodyHasUnknownEncoding(request.headers())) {
                this.logger.log("--> END " + request.method() + " (encoded body omitted)");
            } else if (requestBody.isDuplex()) {
                this.logger.log("--> END " + request.method() + " (duplex request body omitted)");
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                MediaType contentType = requestBody.contentType();
                Object object = contentType;
                if (object == null || (object = object.charset(UTF8)) == null) {
                    Charset charset = UTF8;
                    object = charset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF8");
                }
                Object charset = object;
                this.logger.log("");
                if (Companion.isUtf8$okhttp_logging_interceptor(buffer)) {
                    this.logger.log(buffer.readString((Charset)charset));
                    this.logger.log("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                } else {
                    this.logger.log("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log("<-- HTTP FAILED: " + e);
            throw (Throwable)e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody2 = response.body();
        if (responseBody2 == null) {
            Intrinsics.throwNpe();
        }
        String bodySize = (contentLength = (responseBody = responseBody2).contentLength()) != -1L ? contentLength + "-byte" : "unknown-length";
        CharSequence charSequence = response.message();
        StringBuilder stringBuilder = new StringBuilder().append("<-- ").append(response.code());
        Logger logger = this.logger;
        int n2 = 0;
        boolean bl = charSequence.length() == 0;
        Logger logger2 = logger;
        StringBuilder stringBuilder2 = stringBuilder;
        if (bl) {
            string = "";
        } else {
            char c = ' ';
            String string2 = response.message();
            stringBuilder = stringBuilder2;
            logger = logger2;
            n = 0;
            String string3 = String.valueOf(c) + string2;
            logger2 = logger;
            stringBuilder2 = stringBuilder;
            string = string3;
        }
        logger2.log(stringBuilder2.append(string).append(' ').append(response.request().url()).append(" (").append(tookMs).append("ms").append(!logHeaders ? ", " + bodySize + " body" : "").append(')').toString());
        if (logHeaders) {
            Headers headers = response.headers();
            n2 = 0;
            n = headers.size();
            while (n2 < n) {
                void i;
                this.logHeader(headers, (int)i);
                ++i;
            }
            if (!logBody || !HttpHeaders.promisesBody((Response)response)) {
                this.logger.log("<-- END HTTP");
            } else if (HttpLoggingInterceptor.Companion.bodyHasUnknownEncoding(response.headers())) {
                this.logger.log("<-- END HTTP (encoded body omitted)");
            } else {
                MediaType contentType;
                Object object;
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.getBuffer();
                Long gzippedLength = null;
                if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                    gzippedLength = buffer.size();
                    Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                    boolean bl4 = false;
                    Throwable throwable = null;
                    try {
                        GzipSource gzippedResponseBody = (GzipSource)closeable;
                        boolean bl5 = false;
                        buffer = new Buffer();
                        long l = buffer.writeAll((Source)gzippedResponseBody);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if ((object = (contentType = responseBody.contentType())) == null || (object = object.charset(UTF8)) == null) {
                    Charset charset = UTF8;
                    object = charset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF8");
                }
                Object charset = object;
                if (!Companion.isUtf8$okhttp_logging_interceptor(buffer)) {
                    this.logger.log("");
                    this.logger.log("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                if (contentLength != 0L) {
                    this.logger.log("");
                    this.logger.log(buffer.clone().readString((Charset)charset));
                }
                if (gzippedLength != null) {
                    this.logger.log("<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
                } else {
                    this.logger.log("<-- END HTTP (" + buffer.size() + "-byte body)");
                }
            }
        }
        return response;
    }

    private final void logHeader(Headers headers, int i) {
        String value = this.headersToRedact.contains(headers.name(i)) ? "\u2588\u2588" : headers.value(i);
        this.logger.log(headers.name(i) + ": " + value);
    }

    @JvmOverloads
    public HttpLoggingInterceptor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.headersToRedact = SetsKt.emptySet();
        this.level = Level.NONE;
    }

    @JvmOverloads
    public /* synthetic */ HttpLoggingInterceptor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = Logger.DEFAULT;
        }
        this(logger);
    }

    @JvmOverloads
    public HttpLoggingInterceptor() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        UTF8 = StandardCharsets.UTF_8;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Level;", "", "(Ljava/lang/String;I)V", "NONE", "BASIC", "HEADERS", "BODY", "okhttp-logging-interceptor"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level BASIC;
        public static final /* enum */ Level HEADERS;
        public static final /* enum */ Level BODY;
        private static final /* synthetic */ Level[] $VALUES;

        static {
            Level[] levelArray = new Level[4];
            Level[] levelArray2 = levelArray;
            levelArray[0] = NONE = new Level();
            levelArray[1] = BASIC = new Level();
            levelArray[2] = HEADERS = new Level();
            levelArray[3] = BODY = new Level();
            $VALUES = levelArray;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String string) {
            return Enum.valueOf(Level.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006\u0007"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "", "log", "", "message", "", "Companion", "okhttp-logging-interceptor"})
    public static interface Logger {
        @JvmField
        @NotNull
        public static final Logger DEFAULT;
        public static final Companion Companion;

        public void log(@NotNull String var1);

        static {
            Companion = new Companion(null);
            DEFAULT = new Logger(){

                public void log(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Platform.Companion.get().log(4, message, null);
                }
            };
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0005\u001a\u00020\u00042#\b\u0004\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007H\u0087\n\u00a2\u0006\u0002\b\rR\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006\u000e"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Logger$Companion;", "", "()V", "DEFAULT", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "invoke", "block", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "message", "", "-deprecated_Logger", "okhttp-logging-interceptor"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @JvmName(name="-deprecated_Logger")
            @NotNull
            public final Logger -deprecated_Logger(@NotNull Function1<? super String, Unit> block) {
                int n = 0;
                Intrinsics.checkParameterIsNotNull(block, (String)"block");
                return new Logger(block){
                    final /* synthetic */ Function1 $block;

                    public void log(@NotNull String message) {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        this.$block.invoke((Object)message);
                    }
                    {
                        this.$block = $captured_local_variable$0;
                    }
                };
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0011\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006\r"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Companion;", "", "()V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "isUtf8", "Lokio/Buffer;", "isUtf8$okhttp_logging_interceptor", "okhttp-logging-interceptor"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        public final boolean isUtf8$okhttp_logging_interceptor(@NotNull Buffer $this$isUtf8) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isUtf8, (String)"$this$isUtf8");
            try {
                Buffer prefix = new Buffer();
                long byteCount = $this$isUtf8.size() < (long)64 ? $this$isUtf8.size() : 64L;
                $this$isUtf8.copyTo(prefix, 0L, byteCount);
                int n = 0;
                int n2 = 16;
                while (n < n2 && !prefix.exhausted()) {
                    void i;
                    int codePoint = prefix.readUtf8CodePoint();
                    if (Character.isISOControl(codePoint) && !Character.isWhitespace(codePoint)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            catch (EOFException e) {
                return false;
            }
        }

        private final boolean bodyHasUnknownEncoding(Headers headers) {
            String contentEncoding = headers.get("Content-Encoding");
            return contentEncoding != null && !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

