/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.platform.Platform;
import okhttp3.logging.internal.IsProbablyUtf8Kt;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0003)*+B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u001f\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0014\"\u00020\b\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\r\u0010\r\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0015\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\f\u0010\u000f\u00a8\u0006,"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "<init>", "(Lokhttp3/logging/HttpLoggingInterceptor$Logger;)V", "headersToRedact", "", "", "queryParamsNameToRedact", "value", "Lokhttp3/logging/HttpLoggingInterceptor$Level;", "level", "getLevel", "()Lokhttp3/logging/HttpLoggingInterceptor$Level;", "(Lokhttp3/logging/HttpLoggingInterceptor$Level;)V", "redactHeader", "", "name", "redactQueryParams", "", "([Ljava/lang/String;)V", "setLevel", "-deprecated_level", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "redactUrl", "url", "Lokhttp3/HttpUrl;", "redactUrl$logging_interceptor", "logHeader", "headers", "Lokhttp3/Headers;", "i", "", "bodyHasUnknownEncoding", "", "bodyIsStreaming", "response", "Level", "Logger", "Companion", "logging-interceptor"})
public final class HttpLoggingInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private volatile Set<String> headersToRedact;
    @NotNull
    private volatile Set<String> queryParamsNameToRedact;
    @NotNull
    private volatile Level level;

    @JvmOverloads
    public HttpLoggingInterceptor(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.headersToRedact = SetsKt.emptySet();
        this.queryParamsNameToRedact = SetsKt.emptySet();
        this.level = Level.NONE;
    }

    public /* synthetic */ HttpLoggingInterceptor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = Logger.DEFAULT;
        }
        this(logger);
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @JvmName(name="level")
    public final void level(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.level = level;
    }

    public final void redactHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TreeSet newHeadersToRedact = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        CollectionsKt.addAll((Collection)newHeadersToRedact, (Iterable)this.headersToRedact);
        ((Collection)newHeadersToRedact).add(name);
        this.headersToRedact = newHeadersToRedact;
    }

    public final void redactQueryParams(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TreeSet newQueryParamsNameToRedact = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        CollectionsKt.addAll((Collection)newQueryParamsNameToRedact, (Iterable)this.queryParamsNameToRedact);
        CollectionsKt.addAll((Collection)newQueryParamsNameToRedact, (Object[])name);
        this.queryParamsNameToRedact = newQueryParamsNameToRedact;
    }

    @NotNull
    public final HttpLoggingInterceptor setLevel(@NotNull Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        HttpLoggingInterceptor $this$setLevel_u24lambda_u240 = httpLoggingInterceptor = this;
        boolean bl = false;
        $this$setLevel_u24lambda_u240.level = level;
        return httpLoggingInterceptor;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="level", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_level")
    @NotNull
    public final Level -deprecated_level() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        void $this$intercept_u24lambda_u243;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = "--> " + request.method() + ' ' + this.redactUrl$logging_interceptor(request.url()) + (connection != null ? "" + ' ' + connection.protocol() : "");
        if (!logHeaders && requestBody != null) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.log(requestStartMessage);
        if (logHeaders) {
            Object it;
            Headers headers = request.headers();
            if (requestBody != null) {
                MediaType mediaType = requestBody.contentType();
                if (mediaType != null) {
                    it = mediaType;
                    boolean bl = false;
                    if (headers.get("Content-Type") == null) {
                        this.logger.log("Content-Type: " + it);
                    }
                }
                if (requestBody.contentLength() != -1L && headers.get("Content-Length") == null) {
                    this.logger.log("Content-Length: " + requestBody.contentLength());
                }
            }
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                this.logHeader(headers, i);
            }
            if (!logBody || requestBody == null) {
                this.logger.log("--> END " + request.method());
            } else if (this.bodyHasUnknownEncoding(request.headers())) {
                this.logger.log("--> END " + request.method() + " (encoded body omitted)");
            } else if (requestBody.isDuplex()) {
                this.logger.log("--> END " + request.method() + " (duplex request body omitted)");
            } else if (requestBody.isOneShot()) {
                this.logger.log("--> END " + request.method() + " (one-shot body omitted)");
            } else {
                Buffer buffer = null;
                buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Long gzippedLength = null;
                if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                    gzippedLength = buffer.size();
                    it = (Closeable)new GzipSource((Source)buffer);
                    Throwable throwable = null;
                    try {
                        GzipSource gzippedResponseBody22 = (GzipSource)it;
                        boolean bl = false;
                        buffer = new Buffer();
                        long gzippedResponseBody22 = buffer.writeAll((Source)gzippedResponseBody22);
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)it, (Throwable)throwable);
                    }
                }
                Charset charset = Internal.charsetOrUtf8((MediaType)requestBody.contentType());
                this.logger.log("");
                if (!IsProbablyUtf8Kt.isProbablyUtf8(buffer)) {
                    this.logger.log("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                } else if (gzippedLength != null) {
                    this.logger.log("--> END " + request.method() + " (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
                } else {
                    this.logger.log(buffer.readString(charset));
                    this.logger.log("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.log("<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Logger logger = this.logger;
        int n = 0;
        $this$intercept_u24lambda_u243.append("<-- " + response.code());
        if (((CharSequence)response.message()).length() > 0) {
            $this$intercept_u24lambda_u243.append(' ' + response.message());
        }
        $this$intercept_u24lambda_u243.append(' ' + this.redactUrl$logging_interceptor(response.request().url()) + " (" + tookMs + "ms");
        if (!logHeaders) {
            $this$intercept_u24lambda_u243.append(", " + bodySize + " body");
        }
        $this$intercept_u24lambda_u243.append(")");
        logger.log(stringBuilder.toString());
        if (logHeaders) {
            Headers headers = response.headers();
            n = headers.size();
            for (int i = 0; i < n; ++i) {
                this.logHeader(headers, i);
            }
            if (!logBody || !HttpHeaders.promisesBody((Response)response)) {
                this.logger.log("<-- END HTTP");
            } else if (this.bodyHasUnknownEncoding(response.headers())) {
                this.logger.log("<-- END HTTP (encoded body omitted)");
            } else if (this.bodyIsStreaming(response)) {
                this.logger.log("<-- END HTTP (streaming)");
            } else {
                void $this$intercept_u24lambda_u245;
                Serializable serializable;
                BufferedSource source = responseBody2.source();
                source.request(Long.MAX_VALUE);
                long totalMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                Buffer buffer = null;
                buffer = source.getBuffer();
                Long gzippedLength = null;
                if (StringsKt.equals((String)"gzip", (String)headers.get("Content-Encoding"), (boolean)true)) {
                    gzippedLength = buffer.size();
                    Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                    serializable = null;
                    try {
                        GzipSource gzippedResponseBody32 = (GzipSource)closeable;
                        boolean bl = false;
                        buffer = new Buffer();
                        long gzippedResponseBody32 = buffer.writeAll((Source)gzippedResponseBody32);
                    }
                    catch (Throwable bl) {
                        serializable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
                    }
                }
                Charset charset = Internal.charsetOrUtf8((MediaType)responseBody2.contentType());
                if (!IsProbablyUtf8Kt.isProbablyUtf8(buffer)) {
                    this.logger.log("");
                    this.logger.log("<-- END HTTP (" + totalMs + "ms, binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                if (contentLength != 0L) {
                    this.logger.log("");
                    this.logger.log(buffer.clone().readString(charset));
                }
                serializable = new StringBuilder();
                StringBuilder gzippedResponseBody32 = serializable;
                logger = this.logger;
                boolean bl = false;
                $this$intercept_u24lambda_u245.append("<-- END HTTP (" + totalMs + "ms, " + buffer.size() + "-byte");
                if (gzippedLength != null) {
                    $this$intercept_u24lambda_u245.append(", " + gzippedLength + "-gzipped-byte");
                }
                $this$intercept_u24lambda_u245.append(" body)");
                logger.log(((StringBuilder)serializable).toString());
            }
        }
        return response;
    }

    @NotNull
    public final String redactUrl$logging_interceptor(@NotNull HttpUrl url) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.queryParamsNameToRedact.isEmpty() || url.querySize() == 0) {
            return url.toString();
        }
        HttpUrl.Builder $this$redactUrl_u24lambda_u246 = builder = url.newBuilder().query(null);
        boolean bl = false;
        int n = url.querySize();
        for (int i = 0; i < n; ++i) {
            String parameterName = url.queryParameterName(i);
            String newValue = this.queryParamsNameToRedact.contains(parameterName) ? "\u2588\u2588" : url.queryParameterValue(i);
            $this$redactUrl_u24lambda_u246.addEncodedQueryParameter(parameterName, newValue);
        }
        return builder.toString();
    }

    private final void logHeader(Headers headers, int i) {
        String value = this.headersToRedact.contains(headers.name(i)) ? "\u2588\u2588" : headers.value(i);
        this.logger.log(headers.name(i) + ": " + value);
    }

    private final boolean bodyHasUnknownEncoding(Headers headers) {
        String string = headers.get("Content-Encoding");
        if (string == null) {
            return false;
        }
        String contentEncoding = string;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    private final boolean bodyIsStreaming(Response response) {
        MediaType contentType = response.body().contentType();
        return contentType != null && Intrinsics.areEqual((Object)contentType.type(), (Object)"text") && Intrinsics.areEqual((Object)contentType.subtype(), (Object)"event-stream");
    }

    @JvmOverloads
    public HttpLoggingInterceptor() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Companion;", "", "<init>", "()V", "logging-interceptor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Level;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "BASIC", "HEADERS", "BODY", "logging-interceptor"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE = new Level();
        public static final /* enum */ Level BASIC = new Level();
        public static final /* enum */ Level HEADERS = new Level();
        public static final /* enum */ Level BODY = new Level();
        private static final /* synthetic */ Level[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        @NotNull
        public static EnumEntries<Level> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = levelArray = new Level[]{Level.NONE, Level.BASIC, Level.HEADERS, Level.BODY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "", "log", "", "message", "", "Companion", "logging-interceptor"})
    public static interface Logger {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final Logger DEFAULT = new Companion.DefaultLogger();

        public void log(@NotNull String var1);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Logger$Companion;", "", "<init>", "()V", "DEFAULT", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "DefaultLogger", "logging-interceptor"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lokhttp3/logging/HttpLoggingInterceptor$Logger$Companion$DefaultLogger;", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "<init>", "()V", "log", "", "message", "", "logging-interceptor"})
            private static final class DefaultLogger
            implements Logger {
                @Override
                public void log(@NotNull String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    Platform.log$default((Platform)Platform.Companion.get(), (String)message, (int)0, null, (int)6, null);
                }
            }
        }
    }
}

