//[okhttp](../../../index.md)/[okhttp3](../index.md)/[ConnectionPool](index.md)

# ConnectionPool

[jvm]\
class [ConnectionPool](index.md)

Manages reuse of HTTP and HTTP/2 connections for reduced network latency. HTTP requests that share the same [Address](../-address/index.md) may share a [Connection](../-connection/index.md). This class implements the policy of which connections to keep open for future use.

## Constructors

| | |
|---|---|
| [ConnectionPool](-connection-pool.md) | [jvm]<br>fun [ConnectionPool](-connection-pool.md)(maxIdleConnections: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), keepAliveDuration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)) |
| [ConnectionPool](-connection-pool.md) | [jvm]<br>fun [ConnectionPool](-connection-pool.md)() |

## Functions

| Name | Summary |
|---|---|
| [connectionCount](connection-count.md) | [jvm]<br>fun [connectionCount](connection-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns total number of connections in the pool. |
| [evictAll](evict-all.md) | [jvm]<br>fun [evictAll](evict-all.md)()<br>Close and remove all idle connections in the pool. |
| [idleConnectionCount](idle-connection-count.md) | [jvm]<br>fun [idleConnectionCount](idle-connection-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of idle connections in the pool. |
