//[okhttp](../../../index.md)/[okhttp3](../index.md)/[EventListener](index.md)/[responseBodyStart](response-body-start.md)

# responseBodyStart

[jvm]\
open fun [responseBodyStart](response-body-start.md)(call: [Call](../-call/index.md))

Invoked when data from the response body is first available to the application.

This is typically invoked immediately before bytes are returned to the application. If the response body is empty this is invoked immediately before returning that to the application.

If the application closes the response body before attempting a read, this is invoked at the time it is closed.

The connection is implicit, and will generally relate to the last [connectionAcquired](connection-acquired.md) event.

This will usually be invoked only 1 time for a single [Call](../-call/index.md), exceptions are a limited set of cases including failure recovery.

Prior to OkHttp 4.3 this was incorrectly invoked when the client was ready to read the response body. This was misleading for tracing because it was too early.
