//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Handshake](index.md)

# Handshake

[jvm]\
class [Handshake](index.md)

A record of a TLS handshake. For HTTPS clients, the client is *local* and the remote server is its *peer*.

This value object describes a completed handshake. Use [ConnectionSpec](../-connection-spec/index.md) to set policy for new handshakes.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [cipherSuite](cipher-suite.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;cipherSuite&quot;)<br>val [cipherSuite](cipher-suite.md): [CipherSuite](../-cipher-suite/index.md)<br>Returns the cipher suite used for the connection. |
| [localCertificates](local-certificates.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;localCertificates&quot;)<br>val [localCertificates](local-certificates.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/Certificate.html)&gt;<br>Returns a possibly-empty list of certificates that identify this peer. |
| [localPrincipal](local-principal.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;localPrincipal&quot;)<br>val [localPrincipal](local-principal.md): [Principal](https://docs.oracle.com/javase/8/docs/api/java/security/Principal.html)?<br>Returns the local principle, or null if this peer is anonymous. |
| [peerCertificates](peer-certificates.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;peerCertificates&quot;)<br>val [peerCertificates](peer-certificates.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/Certificate.html)&gt;<br>Returns a possibly-empty list of certificates that identify the remote peer. |
| [peerPrincipal](peer-principal.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;peerPrincipal&quot;)<br>val [peerPrincipal](peer-principal.md): [Principal](https://docs.oracle.com/javase/8/docs/api/java/security/Principal.html)?<br>Returns the remote peer's principle, or null if that peer is anonymous. |
| [tlsVersion](tls-version.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;tlsVersion&quot;)<br>val [tlsVersion](tls-version.md): [TlsVersion](../-tls-version/index.md)<br>Returns the TLS version used for this connection. This value wasn't tracked prior to OkHttp 3.0. For responses cached by preceding versions this returns [TlsVersion.SSL_3_0](../-tls-version/-s-s-l_3_0/index.md). |
