//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Route](index.md)

# Route

[jvm]\
class [Route](index.md)(val address: [Address](../-address/index.md), val proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), val socketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html))

The concrete route used by a connection to reach an abstract origin server. When creating a connection the client has many options:

- 
   **HTTP proxy:** a proxy server may be explicitly configured for the client. Otherwise, the     [proxy selector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html) is used. It may return multiple proxies to attempt.
- 
   **IP address:** whether connecting directly to an origin server or a proxy, opening a socket     requires an IP address. The DNS server may return multiple IP addresses to attempt.

Each route is a specific selection of these options.

## Constructors

| | |
|---|---|
| [Route](-route.md) | [jvm]<br>fun [Route](-route.md)(address: [Address](../-address/index.md), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), socketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html)) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [requiresTunnel](requires-tunnel.md) | [jvm]<br>fun [requiresTunnel](requires-tunnel.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this route tunnels HTTPS or HTTP/2 through an HTTP proxy. See [RFC 2817, Section 5.2](http://www.ietf.org/rfc/rfc2817.txt). |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a string with the URL hostname, socket IP address, and socket port, like one of these: |

## Properties

| Name | Summary |
|---|---|
| [address](address.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;address&quot;)<br>val [address](address.md): [Address](../-address/index.md) |
| [proxy](proxy.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxy&quot;)<br>val [proxy](proxy.md): [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)<br>Returns the [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html) of this route. |
| [socketAddress](socket-address.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;socketAddress&quot;)<br>val [socketAddress](socket-address.md): [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html) |
