//[okhttp](../../../index.md)/[okhttp3](../index.md)/[WebSocketListener](index.md)

# WebSocketListener

[jvm]\
abstract class [WebSocketListener](index.md)

## Constructors

| | |
|---|---|
| [WebSocketListener](-web-socket-listener.md) | [jvm]<br>fun [WebSocketListener](-web-socket-listener.md)() |

## Functions

| Name | Summary |
|---|---|
| [onClosed](on-closed.md) | [jvm]<br>open fun [onClosed](on-closed.md)(webSocket: [WebSocket](../-web-socket/index.md), code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), reason: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>Invoked when both peers have indicated that no more messages will be transmitted and the connection has been successfully released. No further calls to this listener will be made. |
| [onClosing](on-closing.md) | [jvm]<br>open fun [onClosing](on-closing.md)(webSocket: [WebSocket](../-web-socket/index.md), code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), reason: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>Invoked when the remote peer has indicated that no more incoming messages will be transmitted. |
| [onFailure](on-failure.md) | [jvm]<br>open fun [onFailure](on-failure.md)(webSocket: [WebSocket](../-web-socket/index.md), t: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html), response: [Response](../-response/index.md)?)<br>Invoked when a web socket has been closed due to an error reading from or writing to the network. Both outgoing and incoming messages may have been lost. No further calls to this listener will be made. |
| [onMessage](on-message.md) | [jvm]<br>open fun [onMessage](on-message.md)(webSocket: [WebSocket](../-web-socket/index.md), text: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>Invoked when a text (type `0x1`) message has been received.<br>[jvm]<br>open fun [onMessage](on-message.md)(webSocket: [WebSocket](../-web-socket/index.md), bytes: [ByteString](https://square.github.io/okio/2.x/okio/okio/-byte-string/index.html))<br>Invoked when a binary (type `0x2`) message has been received. |
| [onOpen](on-open.md) | [jvm]<br>open fun [onOpen](on-open.md)(webSocket: [WebSocket](../-web-socket/index.md), response: [Response](../-response/index.md))<br>Invoked when a web socket has been accepted by the remote peer and may begin transmitting messages. |
