//[okhttp](../../../index.md)/[okhttp3](../index.md)/[WebSocket](index.md)/[close](close.md)

# close

[jvm]\
abstract fun [close](close.md)(code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), reason: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Attempts to initiate a graceful shutdown of this web socket. Any already-enqueued messages will be transmitted before the close message is sent but subsequent calls to [send](send.md) will return false and their messages will not be enqueued.

This returns true if a graceful shutdown was initiated by this call. It returns false if a graceful shutdown was already underway or if the web socket is already closed or canceled.

#### Parameters

jvm

| | |
|---|---|
| code | Status code as defined by     [Section 7.4 of RFC 6455](http://tools.ietf.org/html/rfc6455#section-7.4). |
| reason | Reason for shutting down, no longer than 123 bytes of UTF-8 encoded data (**not** characters) or null. |

#### Throws

| | |
|---|---|
| [IllegalArgumentException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-argument-exception/index.html) | if [code](close.md) is invalid or [reason](close.md) is too long. |
