//[okio](../../../../index.md)/[okio](../../index.md)/[ByteString](../index.md)/[Companion](index.md)

# Companion

[common, jvm]\
object [Companion](index.md)

## Functions

| Name | Summary |
|---|---|
| [decodeBase64](decode-base64.md) | [common]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[decodeBase64](decode-base64.md)(): [ByteString](../index.md)?<br>Decodes the Base64-encoded bytes and returns their value as a byte string. Returns null if this is not a Base64-encoded sequence of bytes.<br>[jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[decodeBase64](decode-base64.md)(): [ByteString](../index.md)? |
| [decodeHex](decode-hex.md) | [common]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[decodeHex](decode-hex.md)(): [ByteString](../index.md)<br>Decodes the hex-encoded bytes and returns their value a byte string.<br>[jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[decodeHex](decode-hex.md)(): [ByteString](../index.md) |
| [encode](encode.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "encodeString")<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[encode](encode.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html) = Charsets.UTF_8): [ByteString](../index.md)<br>Returns a new [ByteString](../index.md) containing the charset-encoded bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html). |
| [encodeUtf8](encode-utf8.md) | [common]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[encodeUtf8](encode-utf8.md)(): [ByteString](../index.md)<br>Returns a new byte string containing the UTF-8 bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).<br>[jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[encodeUtf8](encode-utf8.md)(): [ByteString](../index.md) |
| [of](of.md) | [common]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [of](of.md)(vararg data: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [ByteString](../index.md)<br>Returns a new byte string containing a clone of the bytes of data.<br>[jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [of](of.md)(vararg data: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [ByteString](../index.md) |
| [readByteString](read-byte-string.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "read")<br>fun [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html).[readByteString](read-byte-string.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../index.md)<br>Reads count bytes from this [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html) and returns the result. |
| [toByteString](to-byte-string.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "of")<br>fun [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html).[toByteString](to-byte-string.md)(): [ByteString](../index.md)<br>Returns a [ByteString](../index.md) containing a copy of this [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html).<br>[common]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html).[toByteString](to-byte-string.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = size): [ByteString](../index.md)<br>Returns a new [ByteString](../index.md) containing a copy of byteCount bytes of this [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) starting at offset.<br>[jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "of")<br>fun [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html).[toByteString](to-byte-string.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = size): [ByteString](../index.md) |

## Properties

| Name | Summary |
|---|---|
| [EMPTY](-e-m-p-t-y.md) | [common]<br>@[JvmField](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-field/index.html)<br>val [EMPTY](-e-m-p-t-y.md): [ByteString](../index.md)<br>A singleton empty ByteString.<br>[jvm]<br>@[JvmField](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-field/index.html)<br>val [EMPTY](-e-m-p-t-y.md): [ByteString](../index.md) |
