//[okio](../../../index.md)/[okio](../index.md)/[Path](index.md)

# Path

[common]\
expect class [Path](index.md) : [Comparable](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-comparable/index.html)&lt;[Path](index.md)&gt; 

A hierarchical address on a file system. A path is an identifier only; a [FileSystem](../-file-system/index.md) is required to access the file that a path refers to, if any.

UNIX and Windows Paths

 ----------------------

Paths follow different rules on UNIX vs. Windows operating systems. On UNIX operating systems (including Linux, Android, macOS, and iOS), the `/` slash character separates path segments. On Windows, the `\` backslash character separates path segments. The two platforms each have their own rules for path resolution. This class implements all rules on all platforms; for example you can model a Linux path in a native Windows application.

Absolute and Relative Paths

 ---------------------------

- 
   **Absolute paths** identify a location independent of any working directory. On UNIX, absolute paths are prefixed with a slash, `/`. On Windows, absolute paths are one of two forms. The first is a volume letter, a colon, and a backslash, like `C:\`. The second is called a Universal Naming Convention (UNC) path, and it is prefixed by two backslashes `\\`. The term ‘fully-qualified path’ is a synonym of ‘absolute path’.
- 
   **Relative paths** are everything else. On their own, relative paths do not identify a location on a file system; they are relative to the system's current working directory. Use [FileSystem.canonicalize](../-file-system/canonicalize.md) to convert a relative path to its absolute path on a particular file system.

There are some special cases when working with relative paths.

On Windows, each volume (like `A:\` and `C:\`) has its own current working directory. A path prefixed with a volume letter and colon but no slash (like `A:letter.doc`) is relative to the working directory on the named volume. For example, if the working directory on `A:\` is `A:\jesse`, then the path `A:letter.doc` resolves to `A:\jesse\letter.doc`.

The path string `C:\Windows` is an absolute path when following Windows rules and a relative path when following UNIX rules. For example, if the current working directory is `/Users/jesse`, then `C:\Windows` resolves to `/Users/jesse/C:/Windows`.

This class decides which rules to follow by inspecting the first slash character in the path string. If the path contains no slash characters, it uses the host platform's rules. Or you may explicitly specify which rules to use by specifying the `directorySeparator` parameter in [toPath](-companion/to-path.md). Pass `"/"` to get UNIX rules and `"\"` to get Windows rules.

Path Traversal

 --------------

After the optional path root (like `/` on UNIX, like `X:\` or `\\` on Windows), the remainder of the path is a sequence of segments separated by `/` or `\` characters. Segments satisfy these rules:

- 
   Segments are always non-empty.
- 
   If the segment is `.`, then the full path must be `.`.
- 
   For normalized paths, if the segment is `..`, then the path must be relative. All `..`     segments precede all other segments. In all cases, a segment `..` cannot be the first segment     of an absolute path.

The only path that ends with `/` is the file system root, `/`. The dot path `.` is a relative path that resolves to whichever path it is resolved against.

The [name](name.md) is the last segment in a path. It is typically a file or directory name, like `README.md` or `Desktop`. The name may be another special value:

- 
   The empty string is the name of the file system root path (full path `/`).
- 
   `.` is the name of the identity relative path (full path `.`).
- 
   `..` is the name of a path consisting of only `..` segments (such as `../../..`).

Comparing Paths

 ---------------

Path implements [Comparable](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-comparable/index.html), [equals](equals.md), and [hashCode](hash-code.md). If two paths are equal then they operate on the same file on the file system.

Note that the converse is not true: **if two paths are non-equal, they may still resolve to the same file on the file system.** Here are some of the ways non-equal paths resolve to the same file:

- 
   **Case differences.** The default file system on macOS is case-insensitive. The paths     `/Users/jesse/notes.txt` and `/USERS/JESSE/NOTES.TXT` are non-equal but these paths resolve to     the same file.
- 
   **Mounting differences.** Volumes may be mounted at multiple paths. On macOS,     `/Users/jesse/notes.txt`  and `/Volumes/Macintosh HD/Users/jesse/notes.txt` typically resolve     to the same file. On Windows, `C:\project\notes.txt` and `\\localhost\c$\project\notes.txt`     typically resolve to the same file.
- 
   **Hard links.** UNIX file systems permit multiple paths to refer for same file. The paths may     be wildly different, like `/Users/jesse/bruce_wayne.vcard` and     `/Users/jesse/batman.vcard`, but changes via either path are reflected in both.
- 
   **Symlinks.** Symlinks permit multiple paths and directories to refer to the same file. On     macOS `/tmp` is symlinked to `/private/tmp`, so `/tmp/notes.txt` and `/private/tmp/notes.txt`     resolve to the same file.

To test whether two paths refer to the same file, try [FileSystem.canonicalize](../-file-system/canonicalize.md) first. This follows symlinks and looks up the preserved casing for case-insensitive case-preserved paths. **This method does not guarantee a unique result, however.** For example, each hard link to a file may return its own canonical path.

Paths are sorted in case-sensitive order.

Sample Paths

 ------------

<table>
<tr><th> Path                         <th> Parent             <th> Root       <th> Name          <th> Notes                          </tr>
<tr><td> `/`                          <td> null               <td> `/`        <td> (empty)       <td> root                           </tr>
<tr><td> `/home/jesse/notes.txt`      <td> `/home/jesse`      <td> `/`        <td> `notes.txt`   <td> absolute path                  </tr>
<tr><td> `project/notes.txt`          <td> `project`          <td> null       <td> `notes.txt`   <td> relative path                  </tr>
<tr><td> `../../project/notes.txt`    <td> `../../project`    <td> null       <td> `notes.txt`   <td> relative path with traversal   </tr>
<tr><td> `../../..`                   <td> null               <td> null       <td> `..`          <td> relative path with traversal   </tr>
<tr><td> `.`                          <td> null               <td> null       <td> `.`           <td> current working directory      </tr>
<tr><td> `C:\`                        <td> null               <td> `C:\`      <td> (empty)       <td> volume root (Windows)          </tr>
<tr><td> `C:\Windows\notepad.exe`     <td> `C:\Windows`       <td> `C:\`      <td> `notepad.exe` <td> volume absolute path (Windows) </tr>
<tr><td> `\`                          <td> null               <td> `\`        <td> (empty)       <td> absolute path (Windows)        </tr>
<tr><td> `\Windows\notepad.exe`       <td> `\Windows`         <td> `\`        <td> `notepad.exe` <td> absolute path (Windows)        </tr>
<tr><td> `C:`                         <td> null               <td> null       <td> (empty)       <td> volume-relative path (Windows) </tr>
<tr><td> `C:project\notes.txt`        <td> `C:project`        <td> null       <td> `notes.txt`   <td> volume-relative path (Windows) </tr>
<tr><td> `\\server`                   <td> null               <td> `\\server` <td> `server`      <td> UNC server (Windows)           </tr>
<tr><td> `\\server\project\notes.txt` <td> `\\server\project` <td> `\\server` <td> `notes.txt`   <td> UNC absolute path (Windows)    </tr>
</table>

[jvm, nonJvm]\
actual class [Path](index.md) : [Comparable](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-comparable/index.html)&lt;[Path](index.md)&gt;

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [isAbsolute](is-absolute.md) | [common]<br>expect val [isAbsolute](is-absolute.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>This is true if [root](root.md) is not null.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual val [isAbsolute](is-absolute.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [isRelative](is-relative.md) | [common]<br>expect val [isRelative](is-relative.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>This is true if [root](root.md) is null.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual val [isRelative](is-relative.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [isRoot](is-root.md) | [common]<br>expect val [isRoot](is-root.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true if `this == this.root`. That is, this is an absolute path with no parent.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual val [isRoot](is-root.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [name](name.md) | [common, jvm, nonJvm]<br>[common]<br>expect val [name](name.md): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;name&quot;)<br>actual val [name](name.md): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>actual val [name](name.md): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html) |
| [nameBytes](name-bytes.md) | [common, jvm, nonJvm]<br>[common]<br>expect val [nameBytes](name-bytes.md): [ByteString](../-byte-string/index.md)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;nameBytes&quot;)<br>actual val [nameBytes](name-bytes.md): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>actual val [nameBytes](name-bytes.md): [ByteString](../-byte-string/index.md) |
| [parent](parent.md) | [common]<br>expect val [parent](parent.md): [Path](index.md)?<br>Returns the path immediately enclosing this path.<br>[jvm, nonJvm]<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;parent&quot;)<br>actual val [parent](parent.md): [Path](index.md)?<br>[nonJvm]<br>actual val [parent](parent.md): [Path](index.md)? |
| [root](root.md) | [common]<br>expect val [root](root.md): [Path](index.md)?<br>This is the root path if this is an absolute path, or null if it is a relative path. UNIX paths have a single root, `/`. Each volume on Windows is its own root, like `C:\` and `D:\`. The path to the current volume `\` is its own root. Windows UNC paths like `\\server` are also roots.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual val [root](root.md): [Path](index.md)? |
| [segments](segments.md) | [common]<br>expect val [segments](segments.md): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)&gt;<br>The components of this path that are usually delimited by slashes. If the root is not null it precedes these segments. If this path is a root its segments list is empty.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual val [segments](segments.md): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)&gt; |
| [segmentsBytes](segments-bytes.md) | [common, jvm, nonJvm]<br>[common]<br>expect val [segmentsBytes](segments-bytes.md): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[ByteString](../-byte-string/index.md)&gt;<br>[jvm, nonJvm]<br>actual val [segmentsBytes](segments-bytes.md): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[ByteString](../-byte-string/index.md)&gt; |
| [volumeLetter](volume-letter.md) | [common]<br>expect val [volumeLetter](volume-letter.md): [Char](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-char/index.html)?<br>This is the volume letter like &quot;C&quot; on Windows paths that starts with a volume letter. For example, on the path &quot;C:\Windows&quot; this returns &quot;C&quot;. This property is null if this is not a Windows path, or if it doesn't have a volume letter.<br>[jvm, nonJvm]<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;volumeLetter&quot;)<br>actual val [volumeLetter](volume-letter.md): [Char](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-char/index.html)?<br>[nonJvm]<br>actual val [volumeLetter](volume-letter.md): [Char](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-char/index.html)? |

## Functions

| Name | Summary |
|---|---|
| [compareTo](compare-to.md) | [common, jvm, nonJvm]<br>[common]<br>expect open operator override fun [compareTo](compare-to.md)(other: [Path](index.md)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual open operator override fun [compareTo](compare-to.md)(other: [Path](index.md)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [div](div.md) | [common]<br>expect operator fun [div](div.md)(child: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Path](index.md)<br>expect operator fun [div](div.md)(child: [ByteString](../-byte-string/index.md)): [Path](index.md)<br>expect operator fun [div](div.md)(child: [Path](index.md)): [Path](index.md)<br>Returns a path that resolves [child](div.md) relative to this path. Note that the result isn't guaranteed to be normalized even if this and [child](div.md) are both normalized themselves.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;resolve&quot;)<br>actual operator fun [div](div.md)(child: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Path](index.md)<br>[nonJvm]<br>actual operator fun [div](div.md)(child: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Path](index.md)<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;resolve&quot;)<br>actual operator fun [div](div.md)(child: [ByteString](../-byte-string/index.md)): [Path](index.md)<br>[nonJvm]<br>actual operator fun [div](div.md)(child: [ByteString](../-byte-string/index.md)): [Path](index.md)<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;resolve&quot;)<br>actual operator fun [div](div.md)(child: [Path](index.md)): [Path](index.md)<br>[nonJvm]<br>actual operator fun [div](div.md)(child: [Path](index.md)): [Path](index.md) |
| [equals](equals.md) | [common, jvm, nonJvm]<br>[common]<br>expect open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [normalized](normalized.md) | [common]<br>expect fun [normalized](normalized.md)(): [Path](index.md)<br>Returns the normalized version of this path. This has the same effect as `this.toString().toPath(normalize = true)`.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [normalized](normalized.md)(): [Path](index.md) |
| [relativeTo](relative-to.md) | [common]<br>expect fun [relativeTo](relative-to.md)(other: [Path](index.md)): [Path](index.md)<br>Returns this path relative to [other](relative-to.md). This effectively inverts the resolve operator, `/`. For any two paths `a` and `b` that have the same root, `a / (b.relativeTo(a))` is equal to `b`. If both paths don't use the same slash, the resolved path will use the slash of the [other](relative-to.md) path.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [relativeTo](relative-to.md)(other: [Path](index.md)): [Path](index.md) |
| [resolve](resolve.md) | [common]<br>expect fun [resolve](resolve.md)(child: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false): [Path](index.md)<br>expect fun [resolve](resolve.md)(child: [ByteString](../-byte-string/index.md), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false): [Path](index.md)<br>expect fun [resolve](resolve.md)(child: [Path](index.md), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false): [Path](index.md)<br>Returns a path that resolves [child](resolve.md) relative to this path.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [resolve](resolve.md)(child: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)): [Path](index.md)<br>[jvm, nonJvm]<br>actual fun [resolve](resolve.md)(child: [ByteString](../-byte-string/index.md), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)): [Path](index.md)<br>[jvm, nonJvm]<br>actual fun [resolve](resolve.md)(child: [Path](index.md), normalize: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)): [Path](index.md) |
| [toFile](to-file.md) | [jvm]<br>fun [toFile](to-file.md)(): [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html) |
| [toNioPath](to-nio-path.md) | [jvm]<br>fun [toNioPath](to-nio-path.md)(): [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html) |
| [toString](to-string.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html) |