/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import retrofit2.Converter;
import retrofit2.converter.gson.GsonStreamingRequestBody;

final class GsonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    static final MediaType MEDIA_TYPE = MediaType.get((String)"application/json; charset=UTF-8");
    private final Gson gson;
    private final TypeAdapter<T> adapter;
    private final boolean streaming;

    GsonRequestBodyConverter(Gson gson, TypeAdapter<T> adapter, boolean streaming) {
        this.gson = gson;
        this.adapter = adapter;
        this.streaming = streaming;
    }

    public RequestBody convert(T value) throws IOException {
        if (this.streaming) {
            return new GsonStreamingRequestBody<T>(this.gson, this.adapter, value);
        }
        Buffer buffer = new Buffer();
        GsonRequestBodyConverter.writeJson((BufferedSink)buffer, this.gson, this.adapter, value);
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }

    static <T> void writeJson(BufferedSink sink, Gson gson, TypeAdapter<T> adapter, T value) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(sink.outputStream(), StandardCharsets.UTF_8);
        JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);
        adapter.write(jsonWriter, value);
        jsonWriter.close();
    }
}

