/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.ProtoType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\t\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/squareup/wire/schema/EmittingRules;", "", "()V", "builder", "Lcom/squareup/wire/schema/EmittingRules$Builder;", "(Lcom/squareup/wire/schema/EmittingRules$Builder;)V", "excludes", "", "", "includes", "isEmpty", "", "()Z", "usedExcludes", "", "usedIncludes", "exclude", "identifier", "type", "Lcom/squareup/wire/schema/ProtoType;", "unusedExcludes", "unusedIncludes", "Builder", "Companion", "wire-schema"})
public final class EmittingRules {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> includes;
    @NotNull
    private final Set<String> excludes;
    @NotNull
    private final Set<String> usedIncludes;
    @NotNull
    private final Set<String> usedExcludes;

    private EmittingRules(Builder builder) {
        this.includes = CollectionsKt.toSet((Iterable)builder.getIncludes$wire_schema());
        this.excludes = CollectionsKt.toSet((Iterable)builder.getExcludes$wire_schema());
        this.usedIncludes = new LinkedHashSet();
        this.usedExcludes = new LinkedHashSet();
    }

    public EmittingRules() {
        this(new Builder());
    }

    public final boolean isEmpty() {
        return this.includes.isEmpty() && this.excludes.isEmpty();
    }

    public final boolean includes(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.includes(type.toString());
    }

    private final boolean includes(String identifier) {
        boolean isIncluded;
        if (this.includes.isEmpty()) {
            return !this.exclude(identifier);
        }
        String includeMatch = null;
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (excludeMatch == null && this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            if (includeMatch == null && this.includes.contains(rule)) {
                includeMatch = rule;
            }
            rule = Companion.enclosing$wire_schema(rule);
        }
        boolean bl = excludeMatch != null && includeMatch != null ? excludeMatch.length() < includeMatch.length() : (excludeMatch != null ? false : (isIncluded = includeMatch != null));
        if (isIncluded) {
            String string = includeMatch;
            Intrinsics.checkNotNull((Object)string);
            this.usedIncludes.add(string);
        } else if (excludeMatch != null) {
            this.usedExcludes.add(excludeMatch);
        }
        return isIncluded;
    }

    private final boolean exclude(String identifier) {
        boolean excluded;
        String includeMatch = null;
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (excludeMatch == null && this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            if (includeMatch == null && this.includes.contains(rule)) {
                includeMatch = rule;
            }
            rule = Companion.enclosing$wire_schema(rule);
        }
        boolean bl = excludeMatch != null && includeMatch != null ? excludeMatch.length() >= includeMatch.length() : (excluded = excludeMatch != null);
        if (excluded) {
            String string = excludeMatch;
            Intrinsics.checkNotNull((Object)string);
            this.usedExcludes.add(string);
        }
        return excluded;
    }

    @NotNull
    public final Set<String> unusedIncludes() {
        return SetsKt.minus(this.includes, (Iterable)this.usedIncludes);
    }

    @NotNull
    public final Set<String> unusedExcludes() {
        return SetsKt.minus(this.excludes, (Iterable)this.usedExcludes);
    }

    public /* synthetic */ EmittingRules(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u0014\u0010\f\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/schema/EmittingRules$Builder;", "", "()V", "excludes", "", "", "getExcludes$wire_schema", "()Ljava/util/Set;", "includes", "getIncludes$wire_schema", "build", "Lcom/squareup/wire/schema/EmittingRules;", "exclude", "identifier", "identifiers", "", "include", "wire-schema"})
    public static final class Builder {
        @NotNull
        private final Set<String> includes = new LinkedHashSet();
        @NotNull
        private final Set<String> excludes = new LinkedHashSet();

        @NotNull
        public final Set<String> getIncludes$wire_schema() {
            return this.includes;
        }

        @NotNull
        public final Set<String> getExcludes$wire_schema() {
            return this.excludes;
        }

        @NotNull
        public final Builder include(@NotNull String identifier) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Builder $this$include_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$include_u24lambda_u2d0.getIncludes$wire_schema().add(identifier);
            return builder;
        }

        @NotNull
        public final Builder include(@NotNull Iterable<String> identifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
            Builder $this$include_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$include_u24lambda_u2d1.getIncludes$wire_schema(), identifiers);
            return builder;
        }

        @NotNull
        public final Builder exclude(@NotNull Iterable<String> identifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
            Builder $this$exclude_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$exclude_u24lambda_u2d2.getExcludes$wire_schema(), identifiers);
            return builder;
        }

        @NotNull
        public final Builder exclude(@NotNull String identifier) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Builder $this$exclude_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$exclude_u24lambda_u2d3.getExcludes$wire_schema().add(identifier);
            return builder;
        }

        @NotNull
        public final EmittingRules build() {
            Set conflictingRules = CollectionsKt.intersect((Iterable)this.includes, (Iterable)this.excludes);
            if (!conflictingRules.isEmpty()) {
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"same rule(s) defined in both includes and excludes: ", (Object)CollectionsKt.joinToString$default((Iterable)conflictingRules, null, null, null, (int)0, null, null, (int)63, null));
                throw new IllegalStateException(string.toString());
            }
            return new EmittingRules(this, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/squareup/wire/schema/EmittingRules$Companion;", "", "()V", "enclosing", "", "identifier", "enclosing$wire_schema", "wire-schema"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String enclosing$wire_schema(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            int from = StringsKt.endsWith$default((String)identifier, (String)".*", (boolean)false, (int)2, null) ? identifier.length() - 3 : identifier.length() - 1;
            int dot = StringsKt.lastIndexOf$default((CharSequence)identifier, (char)'.', (int)from, (boolean)false, (int)4, null);
            if (dot != -1) {
                String string = identifier;
                int n = 0;
                String string2 = string.substring(n, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return Intrinsics.stringPlus((String)string2, (Object)".*");
            }
            if (!Intrinsics.areEqual((Object)identifier, (Object)"*")) {
                return "*";
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

