/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk.build;

import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryJGraphT;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Immutable
public class MavenComponentGraphBuilder {
    public LibraryGraph buildGraph(DependencyNode node, String relativePathToPom) throws MojoExecutionException {
        return this.buildGraph(node, relativePathToPom, null);
    }

    public LibraryGraph buildGraph(DependencyNode node, String relativePathToPom, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        LibraryGraph.Builder depGraphBuilder = this.convertToLibraryGraphBuilder(node, relativePathToPom);
        List children = node.getChildren();
        if (children != null) {
            HashSet<LibraryGraph> result = new HashSet<LibraryGraph>();
            for (DependencyNode child : children) {
                result.addAll(this.buildGraphRecursively(child, relativePathToPom, filter));
            }
            depGraphBuilder.withDirects(result);
        }
        return depGraphBuilder.build();
    }

    private Set<LibraryGraph> buildGraphRecursively(DependencyNode node, String relativePathToPom, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        Artifact nodeArtifact = node.getArtifact();
        List children = node.getChildren();
        if (filter == null || filter.include(nodeArtifact)) {
            LibraryGraph.Builder depGraphBuilder = this.convertToLibraryGraphBuilder(node, relativePathToPom);
            if (children != null) {
                HashSet<LibraryGraph> result = new HashSet<LibraryGraph>();
                for (DependencyNode child : children) {
                    result.addAll(this.buildGraphRecursively(child, relativePathToPom, filter));
                }
                depGraphBuilder.withDirects(result);
            }
            return new HashSet<LibraryGraph>(Collections.singletonList(depGraphBuilder.build()));
        }
        HashSet<LibraryGraph> result = new HashSet<LibraryGraph>();
        if (children != null) {
            for (DependencyNode child : children) {
                result.addAll(this.buildGraphRecursively(child, relativePathToPom, filter));
            }
        }
        return result;
    }

    public LibraryGraph buildGraphWithJGraphT(DependencyNode node, String relativePathToPom) throws MojoExecutionException {
        return this.buildGraphWithJGraphT(node, relativePathToPom, null);
    }

    public LibraryGraph buildGraphWithJGraphT(DependencyNode node, String relativePathToPom, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        LibraryJGraphT graph = new LibraryJGraphT(this.convertToLibraryGraphBuilder(node, relativePathToPom));
        for (DependencyNode child : node.getChildren()) {
            this.buildJGraphT(graph, graph.root(), child, relativePathToPom, filter);
        }
        return graph.toLibraryGraph();
    }

    private void buildJGraphT(LibraryJGraphT graph, LibraryGraph.Builder parent, DependencyNode currentNode, String filename, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (currentNode == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        Artifact nodeArtifact = currentNode.getArtifact();
        List children = currentNode.getChildren();
        if (filter == null || filter.include(nodeArtifact)) {
            LibraryGraph.Builder builder = this.convertToLibraryGraphBuilder(currentNode, filename);
            boolean isAcyclic = graph.dependsOn(parent, builder);
            if (!isAcyclic) {
                return;
            }
            if (children != null) {
                for (DependencyNode child : children) {
                    this.buildJGraphT(graph, builder, child, filename, filter);
                }
            }
            return;
        }
        if (children != null) {
            for (DependencyNode child : children) {
                this.buildJGraphT(graph, parent, child, filename, filter);
            }
        }
    }

    private LibraryGraph.Builder convertToLibraryGraphBuilder(DependencyNode node, String filename) {
        Artifact nodeArtifact = node.getArtifact();
        Coords coords = new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinates(nodeArtifact.getGroupId(), nodeArtifact.getArtifactId()).withVersion(nodeArtifact.getVersion()).withScope(nodeArtifact.getScope()).build();
        return new LibraryGraph.Builder().withCoords(coords).withFilename(filename);
    }
}

