/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.auth.KeyboardInteractiveAuthenticationProvider;
import com.sshtools.common.auth.KeyboardInteractiveProvider;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh2.KBIPrompt;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class KeyboardInteractiveAuthentication<C extends Context>
implements AuthenticationMechanism {
    public static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    public static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    AbstractServerTransport<C> transport;
    AbstractAuthenticationProtocol<C> authentication;
    SshConnection con;
    KeyboardInteractiveAuthenticationProvider[] providers;
    public static final String AUTHENTICATION_METHOD = "keyboard-interactive";
    String username;
    String service;
    KeyboardInteractiveProvider selectedProvider;

    public KeyboardInteractiveAuthentication(AbstractServerTransport<C> transport, AbstractAuthenticationProtocol<C> authentication, SshConnection con, KeyboardInteractiveAuthenticationProvider[] providers) {
        this.transport = transport;
        this.authentication = authentication;
        this.con = con;
        this.providers = providers;
    }

    @Override
    public String getMethod() {
        return AUTHENTICATION_METHOD;
    }

    @Override
    public boolean processMessage(byte[] msg) throws IOException {
        if (msg[0] != 61) {
            return false;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Received SSH_MSG_USERAUTH_INFO_RESPONSE", (Object[])new Object[0]);
        }
        this.con.addTask(ExecutorOperationSupport.EVENTS, new ProcessMessageTask(this.con, msg));
        return true;
    }

    @Override
    public boolean startRequest(String username, byte[] msg) throws IOException {
        this.con.addTask(ExecutorOperationSupport.EVENTS, new StartAuthenticationTask(this.con, username, msg));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInfoRequest(KBIPrompt[] prompts, String name, String instructions) throws IOException {
        try (ByteArrayWriter request = new ByteArrayWriter();){
            request.write(60);
            request.writeString(name);
            request.writeString(instructions);
            request.writeString("");
            request.writeInt(prompts.length);
            for (int i = 0; i < prompts.length; ++i) {
                request.writeString(prompts[i].getPrompt());
                request.writeBoolean(prompts[i].echo());
            }
            this.transport.postMessage(new InfoRequest(request.toByteArray()));
        }
    }

    public KeyboardInteractiveProvider getSelectedProvider() {
        return this.selectedProvider;
    }

    class ProcessMessageTask
    extends ConnectionAwareTask {
        byte[] msg;

        ProcessMessageTask(SshConnection con, byte[] msg) {
            super(con);
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try (ByteArrayReader response = new ByteArrayReader(this.msg);){
                response.read();
                ArrayList<String> answers = new ArrayList<String>();
                int count = (int)response.readInt();
                for (int i = 0; i < count; ++i) {
                    answers.add(response.readString());
                }
                ArrayList<KBIPrompt> additionalPrompts = new ArrayList<KBIPrompt>();
                boolean success = KeyboardInteractiveAuthentication.this.selectedProvider.setResponse(answers.toArray(new String[0]), additionalPrompts);
                if (!additionalPrompts.isEmpty()) {
                    if (KeyboardInteractiveAuthentication.this.authentication.canContinue()) {
                        if (!success) {
                            KeyboardInteractiveAuthentication.this.authentication.markFailed();
                        }
                        KeyboardInteractiveAuthentication.this.sendInfoRequest(additionalPrompts.toArray(new KBIPrompt[0]), KeyboardInteractiveAuthentication.this.selectedProvider.getName(), KeyboardInteractiveAuthentication.this.selectedProvider.getInstruction());
                    } else {
                        KeyboardInteractiveAuthentication.this.authentication.failedAuthentication();
                    }
                } else if (KeyboardInteractiveAuthentication.this.selectedProvider.hasAuthenticated()) {
                    KeyboardInteractiveAuthentication.this.authentication.completedAuthentication();
                } else {
                    KeyboardInteractiveAuthentication.this.authentication.failedAuthentication();
                }
            }
        }
    }

    class StartAuthenticationTask
    extends ConnectionAwareTask {
        String username;
        byte[] msg;

        StartAuthenticationTask(SshConnection con, String username, byte[] msg) {
            super(con);
            this.username = username;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                String languageTag = bar.readString();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Language: {}", (Object[])new Object[]{languageTag});
                }
                String submethods = bar.readString();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Submethods: {}", (Object[])new Object[]{submethods});
                }
                if (KeyboardInteractiveAuthentication.this.selectedProvider == null) {
                    for (KeyboardInteractiveAuthenticationProvider k : KeyboardInteractiveAuthentication.this.providers) {
                        KeyboardInteractiveProvider kp = k.createInstance(this.con);
                        KBIPrompt[] prompts = kp.init(this.con);
                        if (prompts != null) {
                            KeyboardInteractiveAuthentication.this.sendInfoRequest(prompts, kp.getName(), kp.getInstruction());
                            KeyboardInteractiveAuthentication.this.selectedProvider = kp;
                            break;
                        }
                        if (!kp.hasAuthenticated()) continue;
                        KeyboardInteractiveAuthentication.this.selectedProvider = kp;
                        KeyboardInteractiveAuthentication.this.authentication.completedAuthentication();
                    }
                    if (KeyboardInteractiveAuthentication.this.selectedProvider == null) {
                        KeyboardInteractiveAuthentication.this.authentication.failedAuthentication();
                    }
                } else {
                    KBIPrompt[] prompts = KeyboardInteractiveAuthentication.this.selectedProvider.init(this.con);
                    if (prompts != null) {
                        KeyboardInteractiveAuthentication.this.sendInfoRequest(prompts, KeyboardInteractiveAuthentication.this.selectedProvider.getName(), KeyboardInteractiveAuthentication.this.selectedProvider.getInstruction());
                    } else if (KeyboardInteractiveAuthentication.this.selectedProvider.hasAuthenticated()) {
                        KeyboardInteractiveAuthentication.this.authentication.completedAuthentication();
                    } else {
                        KeyboardInteractiveAuthentication.this.authentication.failedAuthentication();
                    }
                }
            }
        }
    }

    class InfoRequest
    implements SshMessage {
        byte[] msg;

        InfoRequest(byte[] msg) {
            this.msg = msg;
        }

        @Override
        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sent SSH_MSG_USERAUTH_INFO_REQUEST", (Object[])new Object[0]);
            }
        }

        @Override
        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put(this.msg);
            return true;
        }
    }
}

