/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.logger.Log;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractMD5Extension;
import com.sshtools.common.util.ByteArrayReader;

public class MD5FileExtension
extends AbstractMD5Extension {
    public static final String EXTENSION_NAME = "md5-hash";

    public MD5FileExtension() {
        super(EXTENSION_NAME);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            String filename = msg.readString();
            long startOffset = msg.readUINT64().longValue();
            long length = msg.readUINT64().longValue();
            byte[] quickCheckHash = msg.readBinaryString();
            byte[] hashValue = this.doMD5Hash(filename, startOffset, length, quickCheckHash, sftp);
            this.sendReply(requestId, hashValue, sftp);
        }
        catch (Exception e) {
            Log.error((String)"Failed to process EXT_MD5_HASH", (Throwable)e, (Object[])new Object[0]);
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
            return;
        }
    }
}

