/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpExtensionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class SftpExtensionLoaderFactory
implements SftpExtensionFactory {
    private Map<String, SftpExtension> extensions = Collections.synchronizedMap(new HashMap());

    public SftpExtensionLoaderFactory() {
        for (SftpExtension ext : ServiceLoader.load(SftpExtension.class, this.getClass().getClassLoader())) {
            this.extensions.put(ext.getName(), ext);
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    @Override
    public SftpExtension getExtension(String requestName) {
        return this.extensions.get(requestName);
    }

    @Override
    public Collection<SftpExtension> getExtensions() {
        return this.extensions.values();
    }
}

