/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.Component;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentInstanceFactory;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshDsaPrivateKey;
import com.sshtools.common.ssh.components.SshDsaPublicKey;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.common.ssh.components.SshRsaPrivateKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.SshSecureRandomGenerator;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ComponentManager {
    private static Map<Class<? extends Component>, Map<String, Boolean>> defaultEnabled = new HashMap<Class<? extends Component>, Map<String, Boolean>>();
    private Set<String> disabledAlgorithms = new HashSet<String>();
    protected static ComponentManager instance;
    ComponentFactory<SshCipher> ssh2ciphersSC;
    ComponentFactory<SshCipher> ssh2ciphersCS;
    ComponentFactory<SshHmac> hmacsCS;
    ComponentFactory<SshHmac> hmacsSC;
    ComponentFactory<SshPublicKey> publickeys;
    ComponentFactory<Digest> digests;
    static Object lock;

    protected ComponentManager() {
        this.disabledAlgorithms.add("ssh-dss");
    }

    public void disableAlgorithm(String algorithm) {
        this.disabledAlgorithms.add(algorithm);
    }

    public boolean isDisabled(String algorithm) {
        return this.disabledAlgorithms.contains(algorithm);
    }

    public void enableAlgorithm(String algorithm) {
        this.disabledAlgorithms.remove(algorithm);
    }

    public static boolean isEnableNoneCipher() {
        return ComponentManager.isDefaultEnabled(SshCipher.class, "none").orElse(false);
    }

    public static void setEnableNoneCipher(boolean enableNoneCipher) {
        ComponentManager.setDefaultEnabled(SshCipher.class, "none", enableNoneCipher);
    }

    public static boolean isEnableNoneMac() {
        return ComponentManager.isDefaultEnabled(SshHmac.class, "none").orElse(false);
    }

    public static void setEnableNoneMac(boolean enableNoneCipher) {
        ComponentManager.setDefaultEnabled(SshHmac.class, "none", enableNoneCipher);
    }

    public static <C extends Component> Optional<Boolean> isDefaultEnabled(Class<C> factoryType, String key) {
        Map<String, Boolean> m = defaultEnabled.get(factoryType);
        if (m == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(m.get(key));
    }

    public static <C extends Component> void setDefaultEnabled(Class<C> componentType, String key, boolean enabled) {
        Map<String, Boolean> m = defaultEnabled.get(componentType);
        if (m == null) {
            m = new HashMap<String, Boolean>();
            defaultEnabled.put(componentType, m);
        }
        m.put(key, enabled);
    }

    public static ComponentManager getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            try {
                instance = new JCEComponentManager();
                instance.init();
                return instance;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to locate a cryptographic provider", e);
            }
        }
    }

    public static ComponentManager getDefaultInstance() {
        return ComponentManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            instance = null;
            ComponentManager.getInstance();
        }
    }

    public abstract ClassLoader getClassLoader();

    public <C extends Component, F extends ComponentInstanceFactory<C>> Iterable<F> loadComponents(Class<C> componentType, Class<F> factoryClass) {
        return ServiceLoader.load(factoryClass, this.getClassLoader()).stream().map(f -> (ComponentInstanceFactory)f.get()).filter(f -> this.isEnabled((ComponentInstanceFactory)f, componentType, f.getKeys()[0])).collect(Collectors.toList());
    }

    public <C extends Component> boolean isEnabled(ComponentInstanceFactory<C> cls, Class<C> type, String name) {
        if (System.getProperties().containsKey(String.format("disable.%s", name))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been explicitly disabled by a system property", (Object[])new Object[]{name});
            }
            return false;
        }
        Optional<Boolean> enabled = ComponentManager.isDefaultEnabled(type, name);
        if (enabled.isEmpty() && !cls.isEnabledByDefault()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been disabled by default by the vendor. It may be re-enabled programatically.", (Object[])new Object[]{name});
            }
            return false;
        }
        if (enabled.isPresent() && !enabled.get().booleanValue()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been disabled programatically.", (Object[])new Object[]{name});
            }
            return false;
        }
        return true;
    }

    protected void init() throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 server->client ciphers", (Object[])new Object[0]);
        }
        this.ssh2ciphersSC = new ComponentFactory(this);
        this.initializeSsh2CipherFactory(this.ssh2ciphersSC);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 client->server ciphers", (Object[])new Object[0]);
        }
        this.ssh2ciphersCS = new ComponentFactory(this);
        this.initializeSsh2CipherFactory(this.ssh2ciphersCS);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 server->client HMACs", (Object[])new Object[0]);
        }
        this.hmacsSC = new ComponentFactory(this);
        this.initializeHmacFactory(this.hmacsSC);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing SSH2 client->server HMACs", (Object[])new Object[0]);
        }
        this.hmacsCS = new ComponentFactory(this);
        this.initializeHmacFactory(this.hmacsCS);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing public keys", (Object[])new Object[0]);
        }
        this.publickeys = new ComponentFactory(this);
        this.initializePublicKeyFactory(this.publickeys);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing digests", (Object[])new Object[0]);
        }
        this.digests = new ComponentFactory(this);
        this.initializeDigestFactory(this.digests);
        if (Log.isInfoEnabled()) {
            Log.info((String)"Initializing Secure Random Number Generator", (Object[])new Object[0]);
        }
        this.getRND().nextInt();
    }

    protected abstract void initializeSsh2CipherFactory(ComponentFactory<SshCipher> var1);

    protected abstract void initializeHmacFactory(ComponentFactory<SshHmac> var1);

    protected abstract void initializePublicKeyFactory(ComponentFactory<SshPublicKey> var1);

    protected abstract void initializeDigestFactory(ComponentFactory<Digest> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(ComponentManager instance) {
        Object object = lock;
        synchronized (object) {
            ComponentManager.instance = instance;
        }
    }

    public ComponentFactory<SshCipher> supportedSsh2CiphersSC() {
        return (ComponentFactory)this.ssh2ciphersSC.clone();
    }

    public ComponentFactory<SshCipher> supportedSsh2CiphersCS() {
        return (ComponentFactory)this.ssh2ciphersCS.clone();
    }

    public ComponentFactory<SshHmac> supportedHMacsSC() {
        return (ComponentFactory)this.hmacsSC.clone();
    }

    public ComponentFactory<SshHmac> supportedHMacsCS() {
        return (ComponentFactory)this.hmacsCS.clone();
    }

    public ComponentFactory<SshPublicKey> supportedPublicKeys() {
        return (ComponentFactory)this.publickeys.clone();
    }

    public ComponentFactory<Digest> supportedDigests() {
        return (ComponentFactory)this.digests.clone();
    }

    public abstract SshKeyPair generateRsaKeyPair(int var1, int var2) throws SshException;

    public abstract SshKeyPair generateEcdsaKeyPair(int var1) throws SshException;

    public abstract SshKeyPair generateEd448KeyPair() throws SshException;

    public abstract SshKeyPair generateEd25519KeyPair() throws SshException;

    public abstract SshRsaPublicKey createRsaPublicKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPublicKey createSsh2RsaPublicKey() throws SshException;

    public abstract SshRsaPrivateKey createRsaPrivateKey(BigInteger var1, BigInteger var2) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6) throws SshException;

    public abstract SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigInteger var7, BigInteger var8) throws SshException;

    public abstract SshKeyPair generateDsaKeyPair(int var1) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4) throws SshException;

    public abstract SshDsaPublicKey createDsaPublicKey();

    public abstract SshDsaPrivateKey createDsaPrivateKey(BigInteger var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5) throws SshException;

    public abstract SshSecureRandomGenerator getRND() throws SshException;

    public Digest getDigest(String name) throws SshException {
        return this.digests.getInstance(name);
    }

    public void setMinimumSecurityLevel(SecurityLevel securityLevel) throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Configuring {} Security", (Object[])new Object[]{securityLevel.name()});
        }
        this.setMinimumSecurityLevel(securityLevel, this.ssh2ciphersCS, "Client->Server Ciphers");
        this.setMinimumSecurityLevel(securityLevel, this.ssh2ciphersSC, "Server->Client Ciphers");
        this.setMinimumSecurityLevel(securityLevel, this.hmacsCS, "Client->Server Macs");
        this.setMinimumSecurityLevel(securityLevel, this.hmacsSC, "Server->Client Macs");
        this.setMinimumSecurityLevel(securityLevel, this.publickeys, "Public Keys");
    }

    private void setMinimumSecurityLevel(SecurityLevel securityLevel, ComponentFactory<?> componentFactory, String name) throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Configuring {}", (Object[])new Object[]{name});
        }
        componentFactory.configureSecurityLevel(securityLevel);
        if (Log.isInfoEnabled()) {
            Log.info((String)componentFactory.list(""), (Object[])new Object[0]);
        }
    }

    static {
        lock = new Object();
    }
}

