/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.zlib;

import com.sshtools.common.ssh.compression.SshCompression;
import com.sshtools.common.ssh.compression.SshCompressionFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZLibCompression
implements SshCompression {
    private static final String ALGORITHM = "zlib";
    private Inflater inflater;
    private Deflater deflater;
    private static final int BUF_SIZE = 65535;
    private ByteBuffer compressOut = ByteBuffer.allocate(65535);
    private ByteBuffer uncompressOut = ByteBuffer.allocate(65535);

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public void init(int type, int level) {
        if (type == 1) {
            this.deflater = new Deflater(level);
        } else if (type == 0) {
            this.inflater = new Inflater();
        }
    }

    @Override
    public byte[] compress(byte[] buf, int start, int len) throws IOException {
        this.compressOut.clear();
        this.deflater.setInput(buf, start, len);
        while (this.deflater.deflate(this.compressOut, 2) > 0) {
        }
        byte[] b = new byte[this.compressOut.position()];
        this.compressOut.flip();
        this.compressOut.get(b);
        return b;
    }

    @Override
    public byte[] uncompress(byte[] buffer, int start, int length) throws IOException {
        this.uncompressOut.clear();
        this.inflater.setInput(buffer, start, length);
        try {
            while (this.inflater.inflate(this.uncompressOut) > 0) {
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Failed to uncompress.", e);
        }
        byte[] b = new byte[this.uncompressOut.position()];
        this.uncompressOut.flip();
        this.uncompressOut.get(b, 0, b.length);
        return b;
    }

    public static class ZLibCompressionFactory
    implements SshCompressionFactory<ZLibCompression> {
        @Override
        public ZLibCompression create() throws NoSuchAlgorithmException, IOException {
            return new ZLibCompression();
        }

        @Override
        public String[] getKeys() {
            return new String[]{ZLibCompression.ALGORITHM};
        }
    }
}

