/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PseudoTerminalModes {
    public static final int VINTR = 1;
    public static final int VQUIT = 2;
    public static final int VERASE = 3;
    public static final int VKILL = 4;
    public static final int VEOF = 5;
    public static final int VEOL = 6;
    public static final int VEOL2 = 7;
    public static final int VSTART = 8;
    public static final int VSTOP = 9;
    public static final int VSUSP = 10;
    public static final int VDSUSP = 11;
    public static final int VREPRINT = 12;
    public static final int VWERASE = 13;
    public static final int VLNEXT = 14;
    public static final int VFLUSH = 15;
    public static final int VSWITCH = 16;
    public static final int VSTATUS = 17;
    public static final int VDISCARD = 18;
    public static final int IGNPAR = 30;
    public static final int PARMRK = 31;
    public static final int INPCK = 32;
    public static final int ISTRIP = 33;
    public static final int INLCR = 34;
    public static final int IGNCR = 35;
    public static final int ICRNL = 36;
    public static final int IUCLC = 37;
    public static final int IXON = 38;
    public static final int IXANY = 39;
    public static final int IXOFF = 40;
    public static final int IMAXBEL = 41;
    public static final int IUTF8 = 42;
    public static final int ISIG = 50;
    public static final int ICANON = 51;
    public static final int XCASE = 52;
    public static final int ECHO = 53;
    public static final int ECHOE = 54;
    public static final int ECHOK = 55;
    public static final int ECHONL = 56;
    public static final int NOFLSH = 57;
    public static final int TOSTOP = 58;
    public static final int IEXTEN = 59;
    public static final int ECHOCTL = 60;
    public static final int ECHOKE = 61;
    public static final int PENDIN = 62;
    public static final int OPOST = 70;
    public static final int OLCUC = 71;
    public static final int ONLCR = 72;
    public static final int OCRNL = 73;
    public static final int ONOCR = 74;
    public static final int ONLRET = 75;
    public static final int CS7 = 90;
    public static final int CS8 = 91;
    public static final int PARENB = 92;
    public static final int PARODD = 93;
    public static final int TTY_OP_ISPEED = 128;
    public static final int TTY_OP_OSPEED = 129;
    @Deprecated(since="3.1.0", forRemoval=true)
    private ByteArrayWriter encodedModes = new ByteArrayWriter();
    private byte[] output;

    @Deprecated(since="3.1.0", forRemoval=true)
    public PseudoTerminalModes() {
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public PseudoTerminalModes(byte[] modes) throws IOException {
        this.output = modes;
    }

    private PseudoTerminalModes(PseudoTerminalModesBuilder builder) {
        builder.codes.forEach((k, v) -> {
            try {
                this.setTerminalMode((int)k, (int)v);
            }
            catch (SshException e) {
                throw new IllegalArgumentException("Failed to set modes.", e);
            }
        });
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void reset() {
        this.output = null;
        this.encodedModes.reset();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setTerminalMode(int mode, int value) throws SshException {
        try {
            this.encodedModes.write(mode);
            this.encodedModes.writeInt(value);
        }
        catch (IOException ex) {
            throw new SshException(5, (Throwable)ex);
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setTerminalMode(int mode, boolean value) throws SshException {
        this.setTerminalMode(mode, value ? 1 : 0);
    }

    public byte[] toByteArray() {
        if (this.output == null) {
            this.encodedModes.write(0);
            this.output = this.encodedModes.toByteArray();
            return this.output;
        }
        return this.output;
    }

    public static final class PseudoTerminalModesBuilder {
        private final Map<Integer, Integer> codes = new LinkedHashMap<Integer, Integer>();
        private byte[] modes;

        public PseudoTerminalModesBuilder reset() {
            this.codes.clear();
            return this;
        }

        public PseudoTerminalModesBuilder withMode(int mode, boolean value) {
            return this.withMode(mode, value ? 1 : 0);
        }

        public PseudoTerminalModesBuilder withMode(int mode, int value) {
            this.codes.put(mode, value);
            return this;
        }

        public PseudoTerminalModesBuilder withMode(int mode) {
            return this.withMode(mode, true);
        }

        public PseudoTerminalModesBuilder withoutMode(int mode) {
            return this.withMode(mode, false);
        }

        public static PseudoTerminalModesBuilder create() {
            return new PseudoTerminalModesBuilder();
        }

        public PseudoTerminalModes build() throws IOException {
            if (Objects.nonNull(this.modes)) {
                return new PseudoTerminalModes(this.modes);
            }
            return new PseudoTerminalModes(this);
        }

        public PseudoTerminalModesBuilder fromBinaryModes(byte[] modes) {
            this.modes = modes;
            return this;
        }
    }
}

