/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class SftpFile {
    private final String filename;
    private final SftpChannel sftp;
    private final String absolutePath;
    private final String longname;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private SftpFileAttributes attrs;

    SftpFile(String path, SftpFileAttributes attrs, SftpChannel sftp, String longname) {
        if (path == null || attrs == null || sftp == null) {
            throw new NullPointerException();
        }
        this.attrs = attrs;
        this.sftp = sftp;
        this.longname = longname;
        String absolutePath = path;
        if (absolutePath.equals("/")) {
            this.filename = "/";
        } else {
            int i;
            if (absolutePath.endsWith("/")) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            this.filename = (i = absolutePath.lastIndexOf(47)) > -1 ? absolutePath.substring(i + 1) : absolutePath;
        }
        this.absolutePath = absolutePath;
    }

    public SftpHandle handle(byte[] handle) {
        return new SftpHandle(handle, this.sftp, this);
    }

    public SftpFileAttributes attributes() {
        return this.attrs;
    }

    public SftpFile attributes(SftpFileAttributes attributes) throws SftpStatusException, SshException {
        this.sftp.setAttributes(this.absolutePath, attributes);
        this.attrs = attributes;
        return this;
    }

    public SftpFile refresh() throws SftpStatusException, SshException {
        this.attrs = this.sftp.getAttributes(this.absolutePath);
        return this;
    }

    public SftpFile getParent() throws SshException, SftpStatusException {
        if (this.absolutePath.lastIndexOf(47) == -1) {
            String dir = this.sftp.getDefaultDirectory();
            return this.sftp.getFile(dir);
        }
        String path = this.sftp.getAbsolutePath(this.absolutePath);
        if (path.equals("/")) {
            return null;
        }
        if (this.filename.equals(".") || this.filename.equals("..")) {
            return this.sftp.getFile(path).getParent();
        }
        int idx = path.lastIndexOf(47);
        String parent = path.substring(0, idx);
        if (parent.equals("")) {
            parent = "/";
        }
        return this.sftp.getFile(parent);
    }

    public String toString() {
        return this.absolutePath;
    }

    public int hashCode() {
        return Objects.hash(this.absolutePath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SftpFile other = (SftpFile)obj;
        return Objects.equals(this.absolutePath, other.absolutePath);
    }

    public String getLongname() {
        return this.longname;
    }

    public void delete() throws SftpStatusException, SshException {
        if (this.sftp == null) {
            throw new SshException("Instance not connected to SFTP subsystem", 4);
        }
        if (this.isDirectory()) {
            this.sftp.removeDirectory(this.getAbsolutePath());
        } else {
            this.sftp.removeFile(this.getAbsolutePath());
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean canWrite() throws SftpStatusException, SshException {
        return this.attrs.permissions().has(new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE});
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean canRead() throws SftpStatusException, SshException {
        return this.attrs.permissions().has(new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
    }

    public SftpChannel getSFTPChannel() {
        return this.sftp;
    }

    public String getFilename() {
        return this.filename;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileAttributes getAttributes() throws SshException, SftpStatusException {
        return this.attrs;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isDirectory() throws SftpStatusException, SshException {
        return this.attrs.isDirectory();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isFile() throws SftpStatusException, SshException {
        return this.attrs.isFile();
    }

    public boolean isLink() throws SftpStatusException, SshException {
        return this.getAttributes().isLink();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isFifo() throws SftpStatusException, SshException {
        return this.getAttributes().isFifo();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isBlock() throws SftpStatusException, SshException {
        return this.getAttributes().isBlock();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isCharacter() throws SftpStatusException, SshException {
        return this.getAttributes().isCharacter();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean isSocket() throws SftpStatusException, SshException {
        return this.getAttributes().isSocket();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    SftpHandle openFile(int flags) throws SftpStatusException, SshException {
        return this.sftp.openFile(this.absolutePath, flags);
    }
}

