/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class SftpFileOutputStream
extends OutputStream {
    private final SftpHandle handle;
    private final SftpChannel sftp;
    private final Vector<UnsignedInteger32> outstandingRequests = new Vector();
    private long position;
    private boolean error = false;

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileOutputStream(SftpFile file) throws SftpStatusException, SshException {
        this.sftp = file.getSFTPChannel();
        this.handle = file.openFile(26);
    }

    SftpFileOutputStream(SftpHandle handle) throws SftpStatusException, SshException {
        this.handle = handle;
        this.sftp = handle.getSFTPChannel();
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        try {
            while (len > 0) {
                int count = Math.min(32768, len);
                this.outstandingRequests.addElement(this.handle.postWriteRequest(this.position, buffer, offset, count));
                this.processNextResponse(100);
                offset += count;
                len -= count;
                this.position += (long)count;
            }
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            byte[] array = new byte[]{(byte)b};
            this.outstandingRequests.addElement(this.handle.postWriteRequest(this.position, array, 0, 1));
            this.processNextResponse(100);
            ++this.position;
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private boolean processNextResponse(int numOutstandingRequests) throws SftpStatusException, SshException {
        try {
            if (this.outstandingRequests.size() > numOutstandingRequests) {
                UnsignedInteger32 requestid = this.outstandingRequests.elementAt(0);
                this.sftp.getOKRequestStatus(requestid);
                this.outstandingRequests.removeElementAt(0);
            }
            return this.outstandingRequests.size() > 0;
        }
        catch (SshException e) {
            this.error = true;
            throw e;
        }
        catch (SftpStatusException e) {
            this.error = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            while (!this.error && this.processNextResponse(0)) {
            }
            this.handle.close();
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

