/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

public class UnsignedInteger32 {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    public static final UnsignedInteger32 ZERO = new UnsignedInteger32(0L);
    private final Long value;

    public UnsignedInteger32(long a) {
        if (a < 0L || a > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        this.value = a;
    }

    public UnsignedInteger32(String a) throws NumberFormatException {
        long longValue = Long.parseLong(a);
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        this.value = longValue;
    }

    public int intValue() {
        return (int)this.value.longValue();
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnsignedInteger32)) {
            return false;
        }
        return ((UnsignedInteger32)o).value.equals(this.value);
    }

    public static UnsignedInteger32 add(UnsignedInteger32 x, UnsignedInteger32 y) {
        return new UnsignedInteger32(x.longValue() + y.longValue());
    }

    public static UnsignedInteger32 add(UnsignedInteger32 x, long y) {
        return new UnsignedInteger32(x.longValue() + y);
    }

    public static UnsignedInteger32 deduct(UnsignedInteger32 x, UnsignedInteger32 y) {
        return new UnsignedInteger32(x.longValue() - y.longValue());
    }

    public static UnsignedInteger32 deduct(UnsignedInteger32 x, long y) {
        return new UnsignedInteger32(x.longValue() - y);
    }
}

