/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.ShippingRateCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.TaxCode;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ShippingRateCreateParams;
import com.stripe.param.ShippingRateListParams;
import com.stripe.param.ShippingRateRetrieveParams;
import com.stripe.param.ShippingRateUpdateParams;
import java.util.Map;
import lombok.Generated;

public class ShippingRate
extends ApiResource
implements HasId,
MetadataStore<ShippingRate> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="delivery_estimate")
    DeliveryEstimate deliveryEstimate;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="fixed_amount")
    FixedAmount fixedAmount;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="tax_behavior")
    String taxBehavior;
    @SerializedName(value="tax_code")
    ExpandableField<TaxCode> taxCode;
    @SerializedName(value="type")
    String type;

    public String getTaxCode() {
        return this.taxCode != null ? this.taxCode.getId() : null;
    }

    public void setTaxCode(String id) {
        this.taxCode = ApiResource.setExpandableFieldId(id, this.taxCode);
    }

    public TaxCode getTaxCodeObject() {
        return this.taxCode != null ? this.taxCode.getExpanded() : null;
    }

    public void setTaxCodeObject(TaxCode expandableObject) {
        this.taxCode = new ExpandableField<TaxCode>(expandableObject.getId(), expandableObject);
    }

    public static ShippingRate create(Map<String, Object> params) throws StripeException {
        return ShippingRate.create(params, (RequestOptions)null);
    }

    public static ShippingRate create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/shipping_rates");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
    }

    public static ShippingRate create(ShippingRateCreateParams params) throws StripeException {
        return ShippingRate.create(params, (RequestOptions)null);
    }

    public static ShippingRate create(ShippingRateCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/shipping_rates");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
    }

    public static ShippingRateCollection list(Map<String, Object> params) throws StripeException {
        return ShippingRate.list(params, (RequestOptions)null);
    }

    public static ShippingRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/shipping_rates");
        return ApiResource.requestCollection(url, params, ShippingRateCollection.class, options);
    }

    public static ShippingRateCollection list(ShippingRateListParams params) throws StripeException {
        return ShippingRate.list(params, (RequestOptions)null);
    }

    public static ShippingRateCollection list(ShippingRateListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/shipping_rates");
        return ApiResource.requestCollection(url, params, ShippingRateCollection.class, options);
    }

    public static ShippingRate retrieve(String shippingRateToken) throws StripeException {
        return ShippingRate.retrieve(shippingRateToken, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ShippingRate retrieve(String shippingRateToken, RequestOptions options) throws StripeException {
        return ShippingRate.retrieve(shippingRateToken, (Map<String, Object>)null, options);
    }

    public static ShippingRate retrieve(String shippingRateToken, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ShippingRate.class, options);
    }

    public static ShippingRate retrieve(String shippingRateToken, ShippingRateRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ShippingRate.class, options);
    }

    public ShippingRate update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public ShippingRate update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
    }

    public ShippingRate update(ShippingRateUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public ShippingRate update(ShippingRateUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ShippingRate.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public DeliveryEstimate getDeliveryEstimate() {
        return this.deliveryEstimate;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public FixedAmount getFixedAmount() {
        return this.fixedAmount;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getTaxBehavior() {
        return this.taxBehavior;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeliveryEstimate(DeliveryEstimate deliveryEstimate) {
        this.deliveryEstimate = deliveryEstimate;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setFixedAmount(FixedAmount fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTaxBehavior(String taxBehavior) {
        this.taxBehavior = taxBehavior;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShippingRate)) {
            return false;
        }
        ShippingRate other = (ShippingRate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        DeliveryEstimate this$deliveryEstimate = this.getDeliveryEstimate();
        DeliveryEstimate other$deliveryEstimate = other.getDeliveryEstimate();
        if (this$deliveryEstimate == null ? other$deliveryEstimate != null : !((Object)this$deliveryEstimate).equals(other$deliveryEstimate)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        FixedAmount this$fixedAmount = this.getFixedAmount();
        FixedAmount other$fixedAmount = other.getFixedAmount();
        if (this$fixedAmount == null ? other$fixedAmount != null : !((Object)this$fixedAmount).equals(other$fixedAmount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$taxBehavior = this.getTaxBehavior();
        String other$taxBehavior = other.getTaxBehavior();
        if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
            return false;
        }
        String this$taxCode = this.getTaxCode();
        String other$taxCode = other.getTaxCode();
        if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShippingRate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        DeliveryEstimate $deliveryEstimate = this.getDeliveryEstimate();
        result = result * 59 + ($deliveryEstimate == null ? 43 : ((Object)$deliveryEstimate).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        FixedAmount $fixedAmount = this.getFixedAmount();
        result = result * 59 + ($fixedAmount == null ? 43 : ((Object)$fixedAmount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $taxBehavior = this.getTaxBehavior();
        result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
        String $taxCode = this.getTaxCode();
        result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class DeliveryEstimate
    extends StripeObject {
        @SerializedName(value="maximum")
        Maximum maximum;
        @SerializedName(value="minimum")
        Minimum minimum;

        @Generated
        public Maximum getMaximum() {
            return this.maximum;
        }

        @Generated
        public Minimum getMinimum() {
            return this.minimum;
        }

        @Generated
        public void setMaximum(Maximum maximum) {
            this.maximum = maximum;
        }

        @Generated
        public void setMinimum(Minimum minimum) {
            this.minimum = minimum;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeliveryEstimate)) {
                return false;
            }
            DeliveryEstimate other = (DeliveryEstimate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Maximum this$maximum = this.getMaximum();
            Maximum other$maximum = other.getMaximum();
            if (this$maximum == null ? other$maximum != null : !((Object)this$maximum).equals(other$maximum)) {
                return false;
            }
            Minimum this$minimum = this.getMinimum();
            Minimum other$minimum = other.getMinimum();
            return !(this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeliveryEstimate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Maximum $maximum = this.getMaximum();
            result = result * 59 + ($maximum == null ? 43 : ((Object)$maximum).hashCode());
            Minimum $minimum = this.getMinimum();
            result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
            return result;
        }

        public static class Maximum
        extends StripeObject {
            @SerializedName(value="unit")
            String unit;
            @SerializedName(value="value")
            Long value;

            @Generated
            public String getUnit() {
                return this.unit;
            }

            @Generated
            public Long getValue() {
                return this.value;
            }

            @Generated
            public void setUnit(String unit) {
                this.unit = unit;
            }

            @Generated
            public void setValue(Long value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Maximum)) {
                    return false;
                }
                Maximum other = (Maximum)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$value = this.getValue();
                Long other$value = other.getValue();
                if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                    return false;
                }
                String this$unit = this.getUnit();
                String other$unit = other.getUnit();
                return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Maximum;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                String $unit = this.getUnit();
                result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                return result;
            }
        }

        public static class Minimum
        extends StripeObject {
            @SerializedName(value="unit")
            String unit;
            @SerializedName(value="value")
            Long value;

            @Generated
            public String getUnit() {
                return this.unit;
            }

            @Generated
            public Long getValue() {
                return this.value;
            }

            @Generated
            public void setUnit(String unit) {
                this.unit = unit;
            }

            @Generated
            public void setValue(Long value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Minimum)) {
                    return false;
                }
                Minimum other = (Minimum)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$value = this.getValue();
                Long other$value = other.getValue();
                if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                    return false;
                }
                String this$unit = this.getUnit();
                String other$unit = other.getUnit();
                return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Minimum;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                String $unit = this.getUnit();
                result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                return result;
            }
        }
    }

    public static class FixedAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="currency_options")
        Map<String, CurrencyOption> currencyOptions;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Map<String, CurrencyOption> getCurrencyOptions() {
            return this.currencyOptions;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setCurrencyOptions(Map<String, CurrencyOption> currencyOptions) {
            this.currencyOptions = currencyOptions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FixedAmount)) {
                return false;
            }
            FixedAmount other = (FixedAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            Map<String, CurrencyOption> this$currencyOptions = this.getCurrencyOptions();
            Map<String, CurrencyOption> other$currencyOptions = other.getCurrencyOptions();
            return !(this$currencyOptions == null ? other$currencyOptions != null : !((Object)this$currencyOptions).equals(other$currencyOptions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FixedAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            Map<String, CurrencyOption> $currencyOptions = this.getCurrencyOptions();
            result = result * 59 + ($currencyOptions == null ? 43 : ((Object)$currencyOptions).hashCode());
            return result;
        }

        public static class CurrencyOption
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="tax_behavior")
            String taxBehavior;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setTaxBehavior(String taxBehavior) {
                this.taxBehavior = taxBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CurrencyOption)) {
                    return false;
                }
                CurrencyOption other = (CurrencyOption)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$taxBehavior = this.getTaxBehavior();
                String other$taxBehavior = other.getTaxBehavior();
                return !(this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CurrencyOption;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $taxBehavior = this.getTaxBehavior();
                result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
                return result;
            }
        }
    }
}

