/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.examples;

import com.stripe.StripeClient;
import com.stripe.model.v2.billing.MeterEventSession;
import com.stripe.param.v2.billing.MeterEventStreamCreateParams;
import java.time.Instant;

public class MeterEventStream {
    private String apiKey;
    private MeterEventSession meterEventSession;

    public MeterEventStream(String apiKey) {
        this.apiKey = apiKey;
    }

    private void refreshMeterEventSession() {
        if (this.meterEventSession == null || this.meterEventSession.getExpiresAt().isBefore(Instant.now())) {
            try {
                StripeClient client = new StripeClient(this.apiKey);
                this.meterEventSession = client.v2().billing().meterEventSession().create();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMeterEvent(String eventName, String stripeCustomerId, String value) {
        this.refreshMeterEventSession();
        MeterEventStreamCreateParams.Event eventParams = MeterEventStreamCreateParams.Event.builder().setEventName(eventName).putPayload("stripe_customer_id", stripeCustomerId).putPayload("value", value).build();
        MeterEventStreamCreateParams params = MeterEventStreamCreateParams.builder().addEvent(eventParams).build();
        try {
            StripeClient client = new StripeClient(this.meterEventSession.getAuthenticationToken());
            client.v2().billing().meterEventStream().create(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String apiKey = "{{API_KEY}}";
        String customerId = "{{CUSTOMER_ID}}";
        MeterEventStream manager = new MeterEventStream(apiKey);
        manager.sendMeterEvent("alpaca_ai_tokens", customerId, "28");
    }
}

