/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.exception.SignatureVerificationException;
import com.stripe.model.Event;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.HttpHeaders;
import com.stripe.net.StripeResponse;
import com.stripe.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Webhook {
    public static final long DEFAULT_TOLERANCE = 300L;

    public static Event constructEvent(String payload, String sigHeader, String secret) throws SignatureVerificationException {
        return Webhook.constructEvent(payload, sigHeader, secret, 300L);
    }

    public static Event constructEvent(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
        return Webhook.constructEvent(payload, sigHeader, secret, tolerance, null);
    }

    public static Event constructEvent(String payload, String sigHeader, String secret, long tolerance, Clock clock) throws SignatureVerificationException {
        Event event = StripeObject.deserializeStripeObject(payload, Event.class, ApiResource.getGlobalResponseGetter());
        Signature.verifyHeader(payload, sigHeader, secret, tolerance, clock);
        if (event.getLastResponse() == null) {
            event.setLastResponse(new StripeResponse(200, HttpHeaders.of(Collections.emptyMap()), payload));
        }
        return event;
    }

    public static final class Signature {
        public static final String EXPECTED_SCHEME = "v1";

        public static boolean verifyHeader(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
            return Signature.verifyHeader(payload, sigHeader, secret, tolerance, null);
        }

        public static boolean verifyHeader(String payload, String sigHeader, String secret, long tolerance, Clock clock) throws SignatureVerificationException {
            long currentTime;
            String expectedSignature;
            long timestamp = Signature.getTimestamp(sigHeader);
            List<String> signatures = Signature.getSignatures(sigHeader, EXPECTED_SCHEME);
            if (timestamp <= 0L) {
                throw new SignatureVerificationException("Unable to extract timestamp and signatures from header", sigHeader);
            }
            if (signatures.size() == 0) {
                throw new SignatureVerificationException("No signatures found with expected scheme", sigHeader);
            }
            String signedPayload = String.format("%d.%s", timestamp, payload);
            try {
                expectedSignature = Signature.computeSignature(signedPayload, secret);
            }
            catch (Exception e) {
                throw new SignatureVerificationException("Unable to compute signature for payload", sigHeader);
            }
            boolean signatureFound = false;
            for (String signature : signatures) {
                if (!StringUtils.secureCompare(expectedSignature, signature)) continue;
                signatureFound = true;
                break;
            }
            if (!signatureFound) {
                throw new SignatureVerificationException("No signatures found matching the expected signature for payload", sigHeader);
            }
            long l = currentTime = clock == null ? Util.getTimeNow() : clock.millis() / 1000L;
            if (tolerance > 0L && timestamp < currentTime - tolerance) {
                throw new SignatureVerificationException("Timestamp outside the tolerance zone", sigHeader);
            }
            return true;
        }

        private static long getTimestamp(String sigHeader) {
            String[] items;
            for (String item : items = sigHeader.split(",", -1)) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals("t")) continue;
                return Long.parseLong(itemParts[1]);
            }
            return -1L;
        }

        private static List<String> getSignatures(String sigHeader, String scheme) {
            String[] items;
            ArrayList<String> signatures = new ArrayList<String>();
            for (String item : items = sigHeader.split(",", -1)) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals(scheme)) continue;
                signatures.add(itemParts[1]);
            }
            return signatures;
        }

        private static String computeSignature(String payload, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
            return Util.computeHmacSha256(secret, payload);
        }
    }

    public static final class Util {
        public static String computeHmacSha256(String key, String message) throws NoSuchAlgorithmException, InvalidKeyException {
            Mac hasher = Mac.getInstance("HmacSHA256");
            hasher.init(new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] hash = hasher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            String result = "";
            for (byte b : hash) {
                result = result + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }

        public static long getTimeNow() {
            long time = System.currentTimeMillis() / 1000L;
            return time;
        }
    }
}

