/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.FeeRefund;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ApplicationFeeRefundCreateParams;
import com.stripe.param.ApplicationFeeRefundListParams;
import com.stripe.param.ApplicationFeeRefundRetrieveParams;
import com.stripe.param.ApplicationFeeRefundUpdateParams;
import java.lang.reflect.Type;

public final class ApplicationFeeRefundService
extends ApiService {
    public ApplicationFeeRefundService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public FeeRefund retrieve(String fee, String id, ApplicationFeeRefundRetrieveParams params) throws StripeException {
        return this.retrieve(fee, id, params, null);
    }

    public FeeRefund retrieve(String fee, String id, RequestOptions options) throws StripeException {
        return this.retrieve(fee, id, null, options);
    }

    public FeeRefund retrieve(String fee, String id) throws StripeException {
        return this.retrieve(fee, id, null, null);
    }

    public FeeRefund retrieve(String fee, String id, ApplicationFeeRefundRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s/refunds/%s", ApiResource.urlEncodeId(fee), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FeeRefund)this.request(request, (Type)((Object)FeeRefund.class));
    }

    public FeeRefund update(String fee, String id, ApplicationFeeRefundUpdateParams params) throws StripeException {
        return this.update(fee, id, params, null);
    }

    public FeeRefund update(String fee, String id, RequestOptions options) throws StripeException {
        return this.update(fee, id, null, options);
    }

    public FeeRefund update(String fee, String id) throws StripeException {
        return this.update(fee, id, null, null);
    }

    public FeeRefund update(String fee, String id, ApplicationFeeRefundUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s/refunds/%s", ApiResource.urlEncodeId(fee), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FeeRefund)this.request(request, (Type)((Object)FeeRefund.class));
    }

    public StripeCollection<FeeRefund> list(String id, ApplicationFeeRefundListParams params) throws StripeException {
        return this.list(id, params, null);
    }

    public StripeCollection<FeeRefund> list(String id, RequestOptions options) throws StripeException {
        return this.list(id, null, options);
    }

    public StripeCollection<FeeRefund> list(String id) throws StripeException {
        return this.list(id, null, null);
    }

    public StripeCollection<FeeRefund> list(String id, ApplicationFeeRefundListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s/refunds", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<FeeRefund>>(){}.getType());
    }

    public FeeRefund create(String id, ApplicationFeeRefundCreateParams params) throws StripeException {
        return this.create(id, params, null);
    }

    public FeeRefund create(String id, RequestOptions options) throws StripeException {
        return this.create(id, null, options);
    }

    public FeeRefund create(String id) throws StripeException {
        return this.create(id, null, null);
    }

    public FeeRefund create(String id, ApplicationFeeRefundCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s/refunds", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FeeRefund)this.request(request, (Type)((Object)FeeRefund.class));
    }
}

