/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.identity;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.identity.VerificationReport;
import com.stripe.model.identity.VerificationSessionCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.VerificationSessionCancelParams;
import com.stripe.param.identity.VerificationSessionCreateParams;
import com.stripe.param.identity.VerificationSessionListParams;
import com.stripe.param.identity.VerificationSessionRedactParams;
import com.stripe.param.identity.VerificationSessionRetrieveParams;
import com.stripe.param.identity.VerificationSessionUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class VerificationSession
extends ApiResource
implements HasId,
MetadataStore<VerificationSession> {
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last_error")
    LastError lastError;
    @SerializedName(value="last_verification_report")
    ExpandableField<VerificationReport> lastVerificationReport;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="options")
    Options options;
    @SerializedName(value="provided_details")
    ProvidedDetails providedDetails;
    @SerializedName(value="redaction")
    Redaction redaction;
    @SerializedName(value="related_customer")
    String relatedCustomer;
    @SerializedName(value="related_person")
    RelatedPerson relatedPerson;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="url")
    String url;
    @SerializedName(value="verification_flow")
    String verificationFlow;
    @SerializedName(value="verified_outputs")
    VerifiedOutputs verifiedOutputs;

    public String getLastVerificationReport() {
        return this.lastVerificationReport != null ? this.lastVerificationReport.getId() : null;
    }

    public void setLastVerificationReport(String id) {
        this.lastVerificationReport = ApiResource.setExpandableFieldId(id, this.lastVerificationReport);
    }

    public VerificationReport getLastVerificationReportObject() {
        return this.lastVerificationReport != null ? this.lastVerificationReport.getExpanded() : null;
    }

    public void setLastVerificationReportObject(VerificationReport expandableObject) {
        this.lastVerificationReport = new ExpandableField<VerificationReport>(expandableObject.getId(), expandableObject);
    }

    public VerificationSession cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public VerificationSession cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public VerificationSession cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public VerificationSession cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession cancel(VerificationSessionCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public VerificationSession cancel(VerificationSessionCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public static VerificationSession create(Map<String, Object> params) throws StripeException {
        return VerificationSession.create(params, (RequestOptions)null);
    }

    public static VerificationSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (VerificationSession)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public static VerificationSession create(VerificationSessionCreateParams params) throws StripeException {
        return VerificationSession.create(params, (RequestOptions)null);
    }

    public static VerificationSession create(VerificationSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSession)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public static VerificationSessionCollection list(Map<String, Object> params) throws StripeException {
        return VerificationSession.list(params, (RequestOptions)null);
    }

    public static VerificationSessionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (VerificationSessionCollection)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSessionCollection.class));
    }

    public static VerificationSessionCollection list(VerificationSessionListParams params) throws StripeException {
        return VerificationSession.list(params, (RequestOptions)null);
    }

    public static VerificationSessionCollection list(VerificationSessionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSessionCollection)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSessionCollection.class));
    }

    public VerificationSession redact() throws StripeException {
        return this.redact((Map<String, Object>)null, (RequestOptions)null);
    }

    public VerificationSession redact(RequestOptions options) throws StripeException {
        return this.redact((Map<String, Object>)null, options);
    }

    public VerificationSession redact(Map<String, Object> params) throws StripeException {
        return this.redact(params, (RequestOptions)null);
    }

    public VerificationSession redact(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/redact", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession redact(VerificationSessionRedactParams params) throws StripeException {
        return this.redact(params, (RequestOptions)null);
    }

    public VerificationSession redact(VerificationSessionRedactParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s/redact", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public static VerificationSession retrieve(String session) throws StripeException {
        return VerificationSession.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static VerificationSession retrieve(String session, RequestOptions options) throws StripeException {
        return VerificationSession.retrieve(session, (Map<String, Object>)null, options);
    }

    public static VerificationSession retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (VerificationSession)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public static VerificationSession retrieve(String session, VerificationSessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(session));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSession)VerificationSession.getGlobalResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public VerificationSession update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    public VerificationSession update(VerificationSessionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public VerificationSession update(VerificationSessionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_sessions/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (VerificationSession)this.getResponseGetter().request(request, (Type)((Object)VerificationSession.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.lastError, responseGetter);
        this.trySetResponseGetter(this.lastVerificationReport, responseGetter);
        this.trySetResponseGetter(this.options, responseGetter);
        this.trySetResponseGetter(this.providedDetails, responseGetter);
        this.trySetResponseGetter(this.redaction, responseGetter);
        this.trySetResponseGetter(this.relatedPerson, responseGetter);
        this.trySetResponseGetter(this.verifiedOutputs, responseGetter);
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public LastError getLastError() {
        return this.lastError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public ProvidedDetails getProvidedDetails() {
        return this.providedDetails;
    }

    @Generated
    public Redaction getRedaction() {
        return this.redaction;
    }

    @Generated
    public String getRelatedCustomer() {
        return this.relatedCustomer;
    }

    @Generated
    public RelatedPerson getRelatedPerson() {
        return this.relatedPerson;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getVerificationFlow() {
        return this.verificationFlow;
    }

    @Generated
    public VerifiedOutputs getVerifiedOutputs() {
        return this.verifiedOutputs;
    }

    @Generated
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastError(LastError lastError) {
        this.lastError = lastError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public void setProvidedDetails(ProvidedDetails providedDetails) {
        this.providedDetails = providedDetails;
    }

    @Generated
    public void setRedaction(Redaction redaction) {
        this.redaction = redaction;
    }

    @Generated
    public void setRelatedCustomer(String relatedCustomer) {
        this.relatedCustomer = relatedCustomer;
    }

    @Generated
    public void setRelatedPerson(RelatedPerson relatedPerson) {
        this.relatedPerson = relatedPerson;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setVerificationFlow(String verificationFlow) {
        this.verificationFlow = verificationFlow;
    }

    @Generated
    public void setVerifiedOutputs(VerifiedOutputs verifiedOutputs) {
        this.verifiedOutputs = verifiedOutputs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerificationSession)) {
            return false;
        }
        VerificationSession other = (VerificationSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LastError this$lastError = this.getLastError();
        LastError other$lastError = other.getLastError();
        if (this$lastError == null ? other$lastError != null : !((Object)this$lastError).equals(other$lastError)) {
            return false;
        }
        String this$lastVerificationReport = this.getLastVerificationReport();
        String other$lastVerificationReport = other.getLastVerificationReport();
        if (this$lastVerificationReport == null ? other$lastVerificationReport != null : !this$lastVerificationReport.equals(other$lastVerificationReport)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        ProvidedDetails this$providedDetails = this.getProvidedDetails();
        ProvidedDetails other$providedDetails = other.getProvidedDetails();
        if (this$providedDetails == null ? other$providedDetails != null : !((Object)this$providedDetails).equals(other$providedDetails)) {
            return false;
        }
        Redaction this$redaction = this.getRedaction();
        Redaction other$redaction = other.getRedaction();
        if (this$redaction == null ? other$redaction != null : !((Object)this$redaction).equals(other$redaction)) {
            return false;
        }
        String this$relatedCustomer = this.getRelatedCustomer();
        String other$relatedCustomer = other.getRelatedCustomer();
        if (this$relatedCustomer == null ? other$relatedCustomer != null : !this$relatedCustomer.equals(other$relatedCustomer)) {
            return false;
        }
        RelatedPerson this$relatedPerson = this.getRelatedPerson();
        RelatedPerson other$relatedPerson = other.getRelatedPerson();
        if (this$relatedPerson == null ? other$relatedPerson != null : !((Object)this$relatedPerson).equals(other$relatedPerson)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$verificationFlow = this.getVerificationFlow();
        String other$verificationFlow = other.getVerificationFlow();
        if (this$verificationFlow == null ? other$verificationFlow != null : !this$verificationFlow.equals(other$verificationFlow)) {
            return false;
        }
        VerifiedOutputs this$verifiedOutputs = this.getVerifiedOutputs();
        VerifiedOutputs other$verifiedOutputs = other.getVerifiedOutputs();
        return !(this$verifiedOutputs == null ? other$verifiedOutputs != null : !((Object)this$verifiedOutputs).equals(other$verifiedOutputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerificationSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LastError $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : ((Object)$lastError).hashCode());
        String $lastVerificationReport = this.getLastVerificationReport();
        result = result * 59 + ($lastVerificationReport == null ? 43 : $lastVerificationReport.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        ProvidedDetails $providedDetails = this.getProvidedDetails();
        result = result * 59 + ($providedDetails == null ? 43 : ((Object)$providedDetails).hashCode());
        Redaction $redaction = this.getRedaction();
        result = result * 59 + ($redaction == null ? 43 : ((Object)$redaction).hashCode());
        String $relatedCustomer = this.getRelatedCustomer();
        result = result * 59 + ($relatedCustomer == null ? 43 : $relatedCustomer.hashCode());
        RelatedPerson $relatedPerson = this.getRelatedPerson();
        result = result * 59 + ($relatedPerson == null ? 43 : ((Object)$relatedPerson).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $verificationFlow = this.getVerificationFlow();
        result = result * 59 + ($verificationFlow == null ? 43 : $verificationFlow.hashCode());
        VerifiedOutputs $verifiedOutputs = this.getVerifiedOutputs();
        result = result * 59 + ($verifiedOutputs == null ? 43 : ((Object)$verifiedOutputs).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class LastError
    extends StripeObject {
        @SerializedName(value="code")
        String code;
        @SerializedName(value="reason")
        String reason;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LastError)) {
                return false;
            }
            LastError other = (LastError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LastError;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }
    }

    public static class Options
    extends StripeObject {
        @SerializedName(value="document")
        Document document;
        @SerializedName(value="email")
        Email email;
        @SerializedName(value="id_number")
        IdNumber idNumber;
        @SerializedName(value="matching")
        Matching matching;
        @SerializedName(value="phone")
        Phone phone;

        @Generated
        public Document getDocument() {
            return this.document;
        }

        @Generated
        public Email getEmail() {
            return this.email;
        }

        @Generated
        public IdNumber getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public Matching getMatching() {
            return this.matching;
        }

        @Generated
        public Phone getPhone() {
            return this.phone;
        }

        @Generated
        public void setDocument(Document document) {
            this.document = document;
        }

        @Generated
        public void setEmail(Email email) {
            this.email = email;
        }

        @Generated
        public void setIdNumber(IdNumber idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public void setMatching(Matching matching) {
            this.matching = matching;
        }

        @Generated
        public void setPhone(Phone phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Document this$document = this.getDocument();
            Document other$document = other.getDocument();
            if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
                return false;
            }
            Email this$email = this.getEmail();
            Email other$email = other.getEmail();
            if (this$email == null ? other$email != null : !((Object)this$email).equals(other$email)) {
                return false;
            }
            IdNumber this$idNumber = this.getIdNumber();
            IdNumber other$idNumber = other.getIdNumber();
            if (this$idNumber == null ? other$idNumber != null : !((Object)this$idNumber).equals(other$idNumber)) {
                return false;
            }
            Matching this$matching = this.getMatching();
            Matching other$matching = other.getMatching();
            if (this$matching == null ? other$matching != null : !((Object)this$matching).equals(other$matching)) {
                return false;
            }
            Phone this$phone = this.getPhone();
            Phone other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !((Object)this$phone).equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Document $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
            Email $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : ((Object)$email).hashCode());
            IdNumber $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : ((Object)$idNumber).hashCode());
            Matching $matching = this.getMatching();
            result = result * 59 + ($matching == null ? 43 : ((Object)$matching).hashCode());
            Phone $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : ((Object)$phone).hashCode());
            return result;
        }

        public static class Document
        extends StripeObject {
            @SerializedName(value="allowed_types")
            List<String> allowedTypes;
            @SerializedName(value="require_id_number")
            Boolean requireIdNumber;
            @SerializedName(value="require_live_capture")
            Boolean requireLiveCapture;
            @SerializedName(value="require_matching_selfie")
            Boolean requireMatchingSelfie;

            @Generated
            public List<String> getAllowedTypes() {
                return this.allowedTypes;
            }

            @Generated
            public Boolean getRequireIdNumber() {
                return this.requireIdNumber;
            }

            @Generated
            public Boolean getRequireLiveCapture() {
                return this.requireLiveCapture;
            }

            @Generated
            public Boolean getRequireMatchingSelfie() {
                return this.requireMatchingSelfie;
            }

            @Generated
            public void setAllowedTypes(List<String> allowedTypes) {
                this.allowedTypes = allowedTypes;
            }

            @Generated
            public void setRequireIdNumber(Boolean requireIdNumber) {
                this.requireIdNumber = requireIdNumber;
            }

            @Generated
            public void setRequireLiveCapture(Boolean requireLiveCapture) {
                this.requireLiveCapture = requireLiveCapture;
            }

            @Generated
            public void setRequireMatchingSelfie(Boolean requireMatchingSelfie) {
                this.requireMatchingSelfie = requireMatchingSelfie;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Document)) {
                    return false;
                }
                Document other = (Document)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireIdNumber = this.getRequireIdNumber();
                Boolean other$requireIdNumber = other.getRequireIdNumber();
                if (this$requireIdNumber == null ? other$requireIdNumber != null : !((Object)this$requireIdNumber).equals(other$requireIdNumber)) {
                    return false;
                }
                Boolean this$requireLiveCapture = this.getRequireLiveCapture();
                Boolean other$requireLiveCapture = other.getRequireLiveCapture();
                if (this$requireLiveCapture == null ? other$requireLiveCapture != null : !((Object)this$requireLiveCapture).equals(other$requireLiveCapture)) {
                    return false;
                }
                Boolean this$requireMatchingSelfie = this.getRequireMatchingSelfie();
                Boolean other$requireMatchingSelfie = other.getRequireMatchingSelfie();
                if (this$requireMatchingSelfie == null ? other$requireMatchingSelfie != null : !((Object)this$requireMatchingSelfie).equals(other$requireMatchingSelfie)) {
                    return false;
                }
                List<String> this$allowedTypes = this.getAllowedTypes();
                List<String> other$allowedTypes = other.getAllowedTypes();
                return !(this$allowedTypes == null ? other$allowedTypes != null : !((Object)this$allowedTypes).equals(other$allowedTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Document;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireIdNumber = this.getRequireIdNumber();
                result = result * 59 + ($requireIdNumber == null ? 43 : ((Object)$requireIdNumber).hashCode());
                Boolean $requireLiveCapture = this.getRequireLiveCapture();
                result = result * 59 + ($requireLiveCapture == null ? 43 : ((Object)$requireLiveCapture).hashCode());
                Boolean $requireMatchingSelfie = this.getRequireMatchingSelfie();
                result = result * 59 + ($requireMatchingSelfie == null ? 43 : ((Object)$requireMatchingSelfie).hashCode());
                List<String> $allowedTypes = this.getAllowedTypes();
                result = result * 59 + ($allowedTypes == null ? 43 : ((Object)$allowedTypes).hashCode());
                return result;
            }
        }

        public static class Email
        extends StripeObject {
            @SerializedName(value="require_verification")
            Boolean requireVerification;

            @Generated
            public Boolean getRequireVerification() {
                return this.requireVerification;
            }

            @Generated
            public void setRequireVerification(Boolean requireVerification) {
                this.requireVerification = requireVerification;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Email)) {
                    return false;
                }
                Email other = (Email)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireVerification = this.getRequireVerification();
                Boolean other$requireVerification = other.getRequireVerification();
                return !(this$requireVerification == null ? other$requireVerification != null : !((Object)this$requireVerification).equals(other$requireVerification));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Email;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireVerification = this.getRequireVerification();
                result = result * 59 + ($requireVerification == null ? 43 : ((Object)$requireVerification).hashCode());
                return result;
            }
        }

        public static class IdNumber
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdNumber)) {
                    return false;
                }
                IdNumber other = (IdNumber)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdNumber;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class Matching
        extends StripeObject {
            @SerializedName(value="dob")
            String dob;
            @SerializedName(value="name")
            String name;

            @Generated
            public String getDob() {
                return this.dob;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setDob(String dob) {
                this.dob = dob;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Matching)) {
                    return false;
                }
                Matching other = (Matching)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$dob = this.getDob();
                String other$dob = other.getDob();
                if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Matching;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $dob = this.getDob();
                result = result * 59 + ($dob == null ? 43 : $dob.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class Phone
        extends StripeObject {
            @SerializedName(value="require_verification")
            Boolean requireVerification;

            @Generated
            public Boolean getRequireVerification() {
                return this.requireVerification;
            }

            @Generated
            public void setRequireVerification(Boolean requireVerification) {
                this.requireVerification = requireVerification;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Phone)) {
                    return false;
                }
                Phone other = (Phone)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$requireVerification = this.getRequireVerification();
                Boolean other$requireVerification = other.getRequireVerification();
                return !(this$requireVerification == null ? other$requireVerification != null : !((Object)this$requireVerification).equals(other$requireVerification));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Phone;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $requireVerification = this.getRequireVerification();
                result = result * 59 + ($requireVerification == null ? 43 : ((Object)$requireVerification).hashCode());
                return result;
            }
        }
    }

    public static class ProvidedDetails
    extends StripeObject {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProvidedDetails)) {
                return false;
            }
            ProvidedDetails other = (ProvidedDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProvidedDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class Redaction
    extends StripeObject {
        @SerializedName(value="status")
        String status;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Redaction)) {
                return false;
            }
            Redaction other = (Redaction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Redaction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class RelatedPerson
    extends StripeObject {
        @SerializedName(value="account")
        String account;
        @SerializedName(value="person")
        String person;

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public String getPerson() {
            return this.person;
        }

        @Generated
        public void setAccount(String account) {
            this.account = account;
        }

        @Generated
        public void setPerson(String person) {
            this.person = person;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelatedPerson)) {
                return false;
            }
            RelatedPerson other = (RelatedPerson)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$person = this.getPerson();
            String other$person = other.getPerson();
            return !(this$person == null ? other$person != null : !this$person.equals(other$person));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelatedPerson;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $person = this.getPerson();
            result = result * 59 + ($person == null ? 43 : $person.hashCode());
            return result;
        }
    }

    public static class VerifiedOutputs
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="dob")
        Dob dob;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="first_name")
        String firstName;
        @SerializedName(value="id_number")
        String idNumber;
        @SerializedName(value="id_number_type")
        String idNumberType;
        @SerializedName(value="last_name")
        String lastName;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="sex")
        String sex;
        @SerializedName(value="unparsed_place_of_birth")
        String unparsedPlaceOfBirth;
        @SerializedName(value="unparsed_sex")
        String unparsedSex;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Dob getDob() {
            return this.dob;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getIdNumber() {
            return this.idNumber;
        }

        @Generated
        public String getIdNumberType() {
            return this.idNumberType;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getSex() {
            return this.sex;
        }

        @Generated
        public String getUnparsedPlaceOfBirth() {
            return this.unparsedPlaceOfBirth;
        }

        @Generated
        public String getUnparsedSex() {
            return this.unparsedSex;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setDob(Dob dob) {
            this.dob = dob;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setIdNumber(String idNumber) {
            this.idNumber = idNumber;
        }

        @Generated
        public void setIdNumberType(String idNumberType) {
            this.idNumberType = idNumberType;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setSex(String sex) {
            this.sex = sex;
        }

        @Generated
        public void setUnparsedPlaceOfBirth(String unparsedPlaceOfBirth) {
            this.unparsedPlaceOfBirth = unparsedPlaceOfBirth;
        }

        @Generated
        public void setUnparsedSex(String unparsedSex) {
            this.unparsedSex = unparsedSex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifiedOutputs)) {
                return false;
            }
            VerifiedOutputs other = (VerifiedOutputs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Dob this$dob = this.getDob();
            Dob other$dob = other.getDob();
            if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$idNumber = this.getIdNumber();
            String other$idNumber = other.getIdNumber();
            if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) {
                return false;
            }
            String this$idNumberType = this.getIdNumberType();
            String other$idNumberType = other.getIdNumberType();
            if (this$idNumberType == null ? other$idNumberType != null : !this$idNumberType.equals(other$idNumberType)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$sex = this.getSex();
            String other$sex = other.getSex();
            if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
                return false;
            }
            String this$unparsedPlaceOfBirth = this.getUnparsedPlaceOfBirth();
            String other$unparsedPlaceOfBirth = other.getUnparsedPlaceOfBirth();
            if (this$unparsedPlaceOfBirth == null ? other$unparsedPlaceOfBirth != null : !this$unparsedPlaceOfBirth.equals(other$unparsedPlaceOfBirth)) {
                return false;
            }
            String this$unparsedSex = this.getUnparsedSex();
            String other$unparsedSex = other.getUnparsedSex();
            return !(this$unparsedSex == null ? other$unparsedSex != null : !this$unparsedSex.equals(other$unparsedSex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerifiedOutputs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Dob $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $idNumber = this.getIdNumber();
            result = result * 59 + ($idNumber == null ? 43 : $idNumber.hashCode());
            String $idNumberType = this.getIdNumberType();
            result = result * 59 + ($idNumberType == null ? 43 : $idNumberType.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $sex = this.getSex();
            result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
            String $unparsedPlaceOfBirth = this.getUnparsedPlaceOfBirth();
            result = result * 59 + ($unparsedPlaceOfBirth == null ? 43 : $unparsedPlaceOfBirth.hashCode());
            String $unparsedSex = this.getUnparsedSex();
            result = result * 59 + ($unparsedSex == null ? 43 : $unparsedSex.hashCode());
            return result;
        }

        public static class Dob
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dob)) {
                    return false;
                }
                Dob other = (Dob)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dob;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }
    }
}

