/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CalculationCreateParams
extends ApiRequestParams {
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="ship_from_details")
    ShipFromDetails shipFromDetails;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="tax_date")
    Long taxDate;

    private CalculationCreateParams(String currency, String customer, CustomerDetails customerDetails, List<String> expand, Map<String, Object> extraParams, List<LineItem> lineItems, ShipFromDetails shipFromDetails, ShippingCost shippingCost, Long taxDate) {
        this.currency = currency;
        this.customer = customer;
        this.customerDetails = customerDetails;
        this.expand = expand;
        this.extraParams = extraParams;
        this.lineItems = lineItems;
        this.shipFromDetails = shipFromDetails;
        this.shippingCost = shippingCost;
        this.taxDate = taxDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public ShipFromDetails getShipFromDetails() {
        return this.shipFromDetails;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public Long getTaxDate() {
        return this.taxDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationCreateParams)) {
            return false;
        }
        CalculationCreateParams other = (CalculationCreateParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taxDate = this.getTaxDate();
        Long other$taxDate = other.getTaxDate();
        if (this$taxDate == null ? other$taxDate != null : !((Object)this$taxDate).equals(other$taxDate)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        CustomerDetails this$customerDetails = this.getCustomerDetails();
        CustomerDetails other$customerDetails = other.getCustomerDetails();
        if (this$customerDetails == null ? other$customerDetails != null : !((Object)this$customerDetails).equals(other$customerDetails)) {
            return false;
        }
        List<String> this$expand = this.getExpand();
        List<String> other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !((Object)this$expand).equals(other$expand)) {
            return false;
        }
        Map<String, Object> this$extraParams = this.getExtraParams();
        Map<String, Object> other$extraParams = other.getExtraParams();
        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
            return false;
        }
        List<LineItem> this$lineItems = this.getLineItems();
        List<LineItem> other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        ShipFromDetails this$shipFromDetails = this.getShipFromDetails();
        ShipFromDetails other$shipFromDetails = other.getShipFromDetails();
        if (this$shipFromDetails == null ? other$shipFromDetails != null : !((Object)this$shipFromDetails).equals(other$shipFromDetails)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        return !(this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculationCreateParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taxDate = this.getTaxDate();
        result = result * 59 + ($taxDate == null ? 43 : ((Object)$taxDate).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        CustomerDetails $customerDetails = this.getCustomerDetails();
        result = result * 59 + ($customerDetails == null ? 43 : ((Object)$customerDetails).hashCode());
        List<String> $expand = this.getExpand();
        result = result * 59 + ($expand == null ? 43 : ((Object)$expand).hashCode());
        Map<String, Object> $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        List<LineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        ShipFromDetails $shipFromDetails = this.getShipFromDetails();
        result = result * 59 + ($shipFromDetails == null ? 43 : ((Object)$shipFromDetails).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        return result;
    }

    public static class CustomerDetails {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_source")
        AddressSource addressSource;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;
        @SerializedName(value="taxability_override")
        TaxabilityOverride taxabilityOverride;

        private CustomerDetails(Address address, AddressSource addressSource, Map<String, Object> extraParams, String ipAddress, List<TaxId> taxIds, TaxabilityOverride taxabilityOverride) {
            this.address = address;
            this.addressSource = addressSource;
            this.extraParams = extraParams;
            this.ipAddress = ipAddress;
            this.taxIds = taxIds;
            this.taxabilityOverride = taxabilityOverride;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public AddressSource getAddressSource() {
            return this.addressSource;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public TaxabilityOverride getTaxabilityOverride() {
            return this.taxabilityOverride;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerDetails)) {
                return false;
            }
            CustomerDetails other = (CustomerDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            AddressSource this$addressSource = this.getAddressSource();
            AddressSource other$addressSource = other.getAddressSource();
            if (this$addressSource == null ? other$addressSource != null : !this$addressSource.equals(other$addressSource)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            List<TaxId> this$taxIds = this.getTaxIds();
            List<TaxId> other$taxIds = other.getTaxIds();
            if (this$taxIds == null ? other$taxIds != null : !((Object)this$taxIds).equals(other$taxIds)) {
                return false;
            }
            TaxabilityOverride this$taxabilityOverride = this.getTaxabilityOverride();
            TaxabilityOverride other$taxabilityOverride = other.getTaxabilityOverride();
            return !(this$taxabilityOverride == null ? other$taxabilityOverride != null : !this$taxabilityOverride.equals(other$taxabilityOverride));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            AddressSource $addressSource = this.getAddressSource();
            result = result * 59 + ($addressSource == null ? 43 : $addressSource.hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            List<TaxId> $taxIds = this.getTaxIds();
            result = result * 59 + ($taxIds == null ? 43 : ((Object)$taxIds).hashCode());
            TaxabilityOverride $taxabilityOverride = this.getTaxabilityOverride();
            result = result * 59 + ($taxabilityOverride == null ? 43 : $taxabilityOverride.hashCode());
            return result;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, String country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$city = this.getCity();
                Object other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$line1 = this.getLine1();
                Object other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                Object this$line2 = this.getLine2();
                Object other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                Object this$postalCode = this.getPostalCode();
                Object other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                Object this$state = this.getState();
                Object other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                Object $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                Object $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                Object $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }

            public static class Builder {
                private Object city;
                private String country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static enum AddressSource implements ApiRequestParams.EnumParam
        {
            BILLING("billing"),
            SHIPPING("shipping");

            private final String value;

            private AddressSource(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum TaxabilityOverride implements ApiRequestParams.EnumParam
        {
            CUSTOMER_EXEMPT("customer_exempt"),
            NONE("none"),
            REVERSE_CHARGE("reverse_charge");

            private final String value;

            private TaxabilityOverride(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Address address;
            private AddressSource addressSource;
            private Map<String, Object> extraParams;
            private String ipAddress;
            private List<TaxId> taxIds;
            private TaxabilityOverride taxabilityOverride;

            public CustomerDetails build() {
                return new CustomerDetails(this.address, this.addressSource, this.extraParams, this.ipAddress, this.taxIds, this.taxabilityOverride);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressSource(AddressSource addressSource) {
                this.addressSource = addressSource;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public Builder addTaxId(TaxId element) {
                if (this.taxIds == null) {
                    this.taxIds = new ArrayList<TaxId>();
                }
                this.taxIds.add(element);
                return this;
            }

            public Builder addAllTaxId(List<TaxId> elements) {
                if (this.taxIds == null) {
                    this.taxIds = new ArrayList<TaxId>();
                }
                this.taxIds.addAll(elements);
                return this;
            }

            public Builder setTaxabilityOverride(TaxabilityOverride taxabilityOverride) {
                this.taxabilityOverride = taxabilityOverride;
                return this;
            }
        }

        public static class TaxId {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="type")
            Type type;
            @SerializedName(value="value")
            String value;

            private TaxId(Map<String, Object> extraParams, Type type, String value) {
                this.extraParams = extraParams;
                this.type = type;
                this.value = value;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxId)) {
                    return false;
                }
                TaxId other = (TaxId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Type this$type = this.getType();
                Type other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxId;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Type $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                AD_NRT("ad_nrt"),
                AE_TRN("ae_trn"),
                AL_TIN("al_tin"),
                AM_TIN("am_tin"),
                AO_TIN("ao_tin"),
                AR_CUIT("ar_cuit"),
                AU_ABN("au_abn"),
                AU_ARN("au_arn"),
                AW_TIN("aw_tin"),
                AZ_TIN("az_tin"),
                BA_TIN("ba_tin"),
                BB_TIN("bb_tin"),
                BD_BIN("bd_bin"),
                BF_IFU("bf_ifu"),
                BG_UIC("bg_uic"),
                BH_VAT("bh_vat"),
                BJ_IFU("bj_ifu"),
                BO_TIN("bo_tin"),
                BR_CNPJ("br_cnpj"),
                BR_CPF("br_cpf"),
                BS_TIN("bs_tin"),
                BY_TIN("by_tin"),
                CA_BN("ca_bn"),
                CA_GST_HST("ca_gst_hst"),
                CA_PST_BC("ca_pst_bc"),
                CA_PST_MB("ca_pst_mb"),
                CA_PST_SK("ca_pst_sk"),
                CA_QST("ca_qst"),
                CD_NIF("cd_nif"),
                CH_UID("ch_uid"),
                CH_VAT("ch_vat"),
                CL_TIN("cl_tin"),
                CM_NIU("cm_niu"),
                CN_TIN("cn_tin"),
                CO_NIT("co_nit"),
                CR_TIN("cr_tin"),
                CV_NIF("cv_nif"),
                DE_STN("de_stn"),
                DO_RCN("do_rcn"),
                EC_RUC("ec_ruc"),
                EG_TIN("eg_tin"),
                ES_CIF("es_cif"),
                ET_TIN("et_tin"),
                EU_OSS_VAT("eu_oss_vat"),
                EU_VAT("eu_vat"),
                GB_VAT("gb_vat"),
                GE_VAT("ge_vat"),
                GN_NIF("gn_nif"),
                HK_BR("hk_br"),
                HR_OIB("hr_oib"),
                HU_TIN("hu_tin"),
                ID_NPWP("id_npwp"),
                IL_VAT("il_vat"),
                IN_GST("in_gst"),
                IS_VAT("is_vat"),
                JP_CN("jp_cn"),
                JP_RN("jp_rn"),
                JP_TRN("jp_trn"),
                KE_PIN("ke_pin"),
                KG_TIN("kg_tin"),
                KH_TIN("kh_tin"),
                KR_BRN("kr_brn"),
                KZ_BIN("kz_bin"),
                LA_TIN("la_tin"),
                LI_UID("li_uid"),
                LI_VAT("li_vat"),
                MA_VAT("ma_vat"),
                MD_VAT("md_vat"),
                ME_PIB("me_pib"),
                MK_VAT("mk_vat"),
                MR_NIF("mr_nif"),
                MX_RFC("mx_rfc"),
                MY_FRP("my_frp"),
                MY_ITN("my_itn"),
                MY_SST("my_sst"),
                NG_TIN("ng_tin"),
                NO_VAT("no_vat"),
                NO_VOEC("no_voec"),
                NP_PAN("np_pan"),
                NZ_GST("nz_gst"),
                OM_VAT("om_vat"),
                PE_RUC("pe_ruc"),
                PH_TIN("ph_tin"),
                RO_TIN("ro_tin"),
                RS_PIB("rs_pib"),
                RU_INN("ru_inn"),
                RU_KPP("ru_kpp"),
                SA_VAT("sa_vat"),
                SG_GST("sg_gst"),
                SG_UEN("sg_uen"),
                SI_TIN("si_tin"),
                SN_NINEA("sn_ninea"),
                SR_FIN("sr_fin"),
                SV_NIT("sv_nit"),
                TH_VAT("th_vat"),
                TJ_TIN("tj_tin"),
                TR_TIN("tr_tin"),
                TW_VAT("tw_vat"),
                TZ_VAT("tz_vat"),
                UA_VAT("ua_vat"),
                UG_TIN("ug_tin"),
                US_EIN("us_ein"),
                UY_RUC("uy_ruc"),
                UZ_TIN("uz_tin"),
                UZ_VAT("uz_vat"),
                VE_RIF("ve_rif"),
                VN_TIN("vn_tin"),
                ZA_VAT("za_vat"),
                ZM_TIN("zm_tin"),
                ZW_TIN("zw_tin");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Type type;
                private String value;

                public TaxId build() {
                    return new TaxId(this.extraParams, this.type, this.value);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }

                public Builder setValue(String value) {
                    this.value = value;
                    return this;
                }
            }
        }
    }

    public static class ShipFromDetails {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private ShipFromDetails(Address address, Map<String, Object> extraParams) {
            this.address = address;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShipFromDetails)) {
                return false;
            }
            ShipFromDetails other = (ShipFromDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShipFromDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            return result;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, String country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$city = this.getCity();
                Object other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$line1 = this.getLine1();
                Object other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                Object this$line2 = this.getLine2();
                Object other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                Object this$postalCode = this.getPostalCode();
                Object other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                Object this$state = this.getState();
                Object other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                Object $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                Object $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                Object $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }

            public static class Builder {
                private Object city;
                private String country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private Map<String, Object> extraParams;

            public ShipFromDetails build() {
                return new ShipFromDetails(this.address, this.extraParams);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class ShippingCost {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="shipping_rate")
        String shippingRate;
        @SerializedName(value="tax_behavior")
        TaxBehavior taxBehavior;
        @SerializedName(value="tax_code")
        String taxCode;

        private ShippingCost(Long amount, Map<String, Object> extraParams, String shippingRate, TaxBehavior taxBehavior, String taxCode) {
            this.amount = amount;
            this.extraParams = extraParams;
            this.shippingRate = shippingRate;
            this.taxBehavior = taxBehavior;
            this.taxCode = taxCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getShippingRate() {
            return this.shippingRate;
        }

        @Generated
        public TaxBehavior getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShippingCost)) {
                return false;
            }
            ShippingCost other = (ShippingCost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            String this$shippingRate = this.getShippingRate();
            String other$shippingRate = other.getShippingRate();
            if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) {
                return false;
            }
            TaxBehavior this$taxBehavior = this.getTaxBehavior();
            TaxBehavior other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            String this$taxCode = this.getTaxCode();
            String other$taxCode = other.getTaxCode();
            return !(this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ShippingCost;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            String $shippingRate = this.getShippingRate();
            result = result * 59 + ($shippingRate == null ? 43 : $shippingRate.hashCode());
            TaxBehavior $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            String $taxCode = this.getTaxCode();
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            return result;
        }

        public static enum TaxBehavior implements ApiRequestParams.EnumParam
        {
            EXCLUSIVE("exclusive"),
            INCLUSIVE("inclusive");

            private final String value;

            private TaxBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;
            private String shippingRate;
            private TaxBehavior taxBehavior;
            private String taxCode;

            public ShippingCost build() {
                return new ShippingCost(this.amount, this.extraParams, this.shippingRate, this.taxBehavior, this.taxCode);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setShippingRate(String shippingRate) {
                this.shippingRate = shippingRate;
                return this;
            }

            public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                this.taxBehavior = taxBehavior;
                return this;
            }

            public Builder setTaxCode(String taxCode) {
                this.taxCode = taxCode;
                return this;
            }
        }
    }

    public static class Builder {
        private String currency;
        private String customer;
        private CustomerDetails customerDetails;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private List<LineItem> lineItems;
        private ShipFromDetails shipFromDetails;
        private ShippingCost shippingCost;
        private Long taxDate;

        public CalculationCreateParams build() {
            return new CalculationCreateParams(this.currency, this.customer, this.customerDetails, this.expand, this.extraParams, this.lineItems, this.shipFromDetails, this.shippingCost, this.taxDate);
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerDetails(CustomerDetails customerDetails) {
            this.customerDetails = customerDetails;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder setShipFromDetails(ShipFromDetails shipFromDetails) {
            this.shipFromDetails = shipFromDetails;
            return this;
        }

        public Builder setShippingCost(ShippingCost shippingCost) {
            this.shippingCost = shippingCost;
            return this;
        }

        public Builder setTaxDate(Long taxDate) {
            this.taxDate = taxDate;
            return this;
        }
    }

    public static class LineItem {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="product")
        String product;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="reference")
        String reference;
        @SerializedName(value="tax_behavior")
        TaxBehavior taxBehavior;
        @SerializedName(value="tax_code")
        String taxCode;

        private LineItem(Long amount, Map<String, Object> extraParams, Map<String, String> metadata, String product, Long quantity, String reference, TaxBehavior taxBehavior, String taxCode) {
            this.amount = amount;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.product = product;
            this.quantity = quantity;
            this.reference = reference;
            this.taxBehavior = taxBehavior;
            this.taxCode = taxCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getProduct() {
            return this.product;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public TaxBehavior getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineItem)) {
                return false;
            }
            LineItem other = (LineItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$product = this.getProduct();
            String other$product = other.getProduct();
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            TaxBehavior this$taxBehavior = this.getTaxBehavior();
            TaxBehavior other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            String this$taxCode = this.getTaxCode();
            String other$taxCode = other.getTaxCode();
            return !(this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LineItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $product = this.getProduct();
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            TaxBehavior $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            String $taxCode = this.getTaxCode();
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            return result;
        }

        public static enum TaxBehavior implements ApiRequestParams.EnumParam
        {
            EXCLUSIVE("exclusive"),
            INCLUSIVE("inclusive");

            private final String value;

            private TaxBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String product;
            private Long quantity;
            private String reference;
            private TaxBehavior taxBehavior;
            private String taxCode;

            public LineItem build() {
                return new LineItem(this.amount, this.extraParams, this.metadata, this.product, this.quantity, this.reference, this.taxBehavior, this.taxCode);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setProduct(String product) {
                this.product = product;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setReference(String reference) {
                this.reference = reference;
                return this;
            }

            public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                this.taxBehavior = taxBehavior;
                return this;
            }

            public Builder setTaxCode(String taxCode) {
                this.taxCode = taxCode;
                return this;
            }
        }
    }
}

