/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.structurizr.documentation.DocumentationContent;
import com.structurizr.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class Decision
extends DocumentationContent {
    private String id;
    private String title;
    private Date date;
    private String status;
    private Set<Link> links = new HashSet<Link>();

    Decision() {
    }

    public Decision(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.links);
    }

    void setLinks(Set<Link> links) {
        this.links = links;
    }

    public void addLink(Decision decision, String type) {
        if (!decision.getId().equals(this.getId())) {
            this.links.add(new Link(decision.getId(), type));
        }
    }

    public boolean hasLinkTo(Decision decision) {
        return this.links.stream().anyMatch(l -> l.getId().equals(decision.getId()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Decision decision = (Decision)object;
        if (this.getElementId() != null) {
            return this.getElementId().equals(decision.getElementId()) && this.getId().equals(decision.getId());
        }
        return this.getId().equals(decision.getId());
    }

    public int hashCode() {
        int result = this.getElementId() != null ? this.getElementId().hashCode() : 0;
        result = 31 * result + this.getId().hashCode();
        return result;
    }

    public static final class Link {
        private String id;
        private String description = "";

        Link() {
        }

        Link(String id, String description) {
            if (StringUtils.isNullOrEmpty(id)) {
                throw new IllegalArgumentException("Link ID must be specified");
            }
            this.setId(id);
            this.setDescription(description);
        }

        public String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        void setDescription(String description) {
            this.description = !StringUtils.isNullOrEmpty(description) ? description : "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            if (!this.description.equals(link.description)) {
                return false;
            }
            return this.id.equals(link.id);
        }

        public int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

