/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;

public final class SoftwareSystemInstance
extends StaticStructureElementInstance {
    private SoftwareSystem softwareSystem;
    private String softwareSystemId;

    SoftwareSystemInstance() {
    }

    SoftwareSystemInstance(SoftwareSystem softwareSystem, int instanceId, String environment, String ... deploymentGroups) {
        super(instanceId, environment, deploymentGroups);
        this.setSoftwareSystem(softwareSystem);
        this.addTags("Software System Instance");
    }

    @JsonIgnore
    public SoftwareSystem getSoftwareSystem() {
        return this.softwareSystem;
    }

    void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.softwareSystem = softwareSystem;
    }

    @Override
    public StaticStructureElement getElement() {
        return this.getSoftwareSystem();
    }

    public String getSoftwareSystemId() {
        if (this.softwareSystem != null) {
            return this.softwareSystem.getId();
        }
        return this.softwareSystemId;
    }

    void setSoftwareSystemId(String softwareSystemId) {
        this.softwareSystemId = softwareSystemId;
    }

    @Override
    @JsonIgnore
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }
}

